/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;

public final class MetricsStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        CompositeMeterRegistry transitionMeterRegistry = (CompositeMeterRegistry)context.getPartitionTransitionMeterRegistry();
        if (transitionMeterRegistry != null) {
            MicrometerUtil.discard((CompositeMeterRegistry)transitionMeterRegistry);
            context.setPartitionTransitionMeterRegistry(null);
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        MeterRegistry startupMeterRegistry = context.getPartitionStartupMeterRegistry();
        CompositeMeterRegistry transitionRegistry = MicrometerUtil.wrap((MeterRegistry)startupMeterRegistry, (Tags)MicrometerUtil.PartitionKeyNames.tags((int)context.getPartitionId()));
        context.setPartitionTransitionMeterRegistry((MeterRegistry)transitionRegistry);
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public String getName() {
        return "Metrics";
    }
}

