/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.adminapi;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.adminapi.ApiRequestReader;
import io.camunda.zeebe.broker.transport.adminapi.ApiResponseWriter;
import io.camunda.zeebe.protocol.management.AdminRequestType;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.Either;
import java.util.Optional;

public class AdminApiRequestHandler
extends AsyncApiRequestHandler<ApiRequestReader, ApiResponseWriter> {
    private final AtomixServerTransport transport;
    private final PartitionAdminAccess adminAccess;
    private final RaftPartition raftPartition;

    public AdminApiRequestHandler(AtomixServerTransport transport, PartitionAdminAccess adminAccess, RaftPartition raftPartition) {
        super(ApiRequestReader::new, ApiResponseWriter::new);
        this.transport = transport;
        this.adminAccess = adminAccess;
        this.raftPartition = raftPartition;
    }

    protected void onActorStarting() {
        this.transport.subscribe(((Integer)this.raftPartition.id().id()).intValue(), RequestType.ADMIN, (RequestHandler)this);
    }

    protected void onActorClosing() {
        this.transport.unsubscribe(((Integer)this.raftPartition.id().id()).intValue(), RequestType.ADMIN);
    }

    @Override
    protected ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> handleAsync(int partitionId, long requestId, ApiRequestReader requestReader, ApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        return switch (requestReader.getMessageDecoder().type()) {
            case AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY -> CompletableActorFuture.completed(this.stepDownIfNotPrimary(responseWriter, partitionId, errorWriter));
            case AdminRequestType.PAUSE_EXPORTING -> this.pauseExporting(responseWriter, partitionId, errorWriter);
            case AdminRequestType.SOFT_PAUSE_EXPORTING -> this.softPauseExporting(responseWriter, partitionId, errorWriter);
            case AdminRequestType.RESUME_EXPORTING -> this.resumeExporting(responseWriter, partitionId, errorWriter);
            case AdminRequestType.BAN_INSTANCE -> this.banInstance(requestReader, responseWriter, partitionId, errorWriter);
            default -> this.unknownRequest(errorWriter, requestReader.getMessageDecoder().type());
        };
    }

    private ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> banInstance(ApiRequestReader requestReader, ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        long key = requestReader.key();
        ActorFuture result = this.actor.createFuture();
        this.adminAccess.banInstance(requestReader.key()).onComplete((r, t) -> {
            if (t == null) {
                result.complete((Object)Either.right((Object)responseWriter));
            } else {
                LOG.error("Failed to ban instance {} on partition {}", new Object[]{key, partitionId, t});
                result.complete((Object)Either.left((Object)errorWriter.internalError("Failed to ban instance %s, on partition %s", key, partitionId)));
            }
        });
        return result;
    }

    private ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> unknownRequest(ErrorResponseWriter errorWriter, AdminRequestType type) {
        errorWriter.unsupportedMessage(type, AdminRequestType.values());
        return CompletableActorFuture.completed((Object)Either.left((Object)errorWriter));
    }

    private ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> pauseExporting(ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        Optional<PartitionAdminAccess> partitionAdminAccess = this.adminAccess.forPartition(partitionId);
        if (partitionAdminAccess.isEmpty()) {
            return CompletableActorFuture.completed((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to pause exporting. Could not find the partition.", partitionId)));
        }
        ActorFuture result = this.actor.createFuture();
        partitionAdminAccess.orElseThrow().pauseExporting().onComplete((r, t) -> {
            if (t == null) {
                result.complete((Object)Either.right((Object)responseWriter));
            } else {
                LOG.error("Failed to pause exporting on partition {}", (Object)partitionId, t);
                result.complete((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to pause exporting", partitionId)));
            }
        });
        return result;
    }

    private ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> softPauseExporting(ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        Optional<PartitionAdminAccess> partitionAdminAccess = this.adminAccess.forPartition(partitionId);
        if (partitionAdminAccess.isEmpty()) {
            return CompletableActorFuture.completed((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to soft pause exporting. Could not find the partition.", partitionId)));
        }
        ActorFuture result = this.actor.createFuture();
        partitionAdminAccess.orElseThrow().softPauseExporting().onComplete((r, t) -> {
            if (t == null) {
                result.complete((Object)Either.right((Object)responseWriter));
            } else {
                LOG.error("Failed to soft pause exporting on partition {}", (Object)partitionId, t);
                result.complete((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to soft pause exporting", partitionId)));
            }
        });
        return result;
    }

    private ActorFuture<Either<ErrorResponseWriter, ApiResponseWriter>> resumeExporting(ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        Optional<PartitionAdminAccess> partitionAdminAccess = this.adminAccess.forPartition(partitionId);
        if (partitionAdminAccess.isEmpty()) {
            return CompletableActorFuture.completed((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to resume exporting. Could not find the partition.", partitionId)));
        }
        ActorFuture result = this.actor.createFuture();
        partitionAdminAccess.orElseThrow().resumeExporting().onComplete((r, t) -> {
            if (t == null) {
                result.complete((Object)Either.right((Object)responseWriter));
            } else {
                LOG.error("Failed to resume exporting on partition {}", (Object)partitionId, t);
                result.complete((Object)Either.left((Object)errorWriter.internalError("Partition %s failed to resume exporting", partitionId)));
            }
        });
        return result;
    }

    private Either<ErrorResponseWriter, ApiResponseWriter> stepDownIfNotPrimary(ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        if (this.raftPartition.getRole() != RaftServer.Role.LEADER) {
            errorWriter.partitionLeaderMismatch(partitionId);
            return Either.left((Object)errorWriter);
        }
        this.raftPartition.stepDownIfNotPrimary();
        return Either.right((Object)responseWriter);
    }
}

