/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import io.camunda.zeebe.broker.transport.backpressure.BackpressureMetricsDoc;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.agrona.collections.Int2ObjectHashMap;

public final class BackpressureMetrics {
    private final Int2ObjectHashMap<Counter> droppedRequestCount = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Counter> totalRequestCount = new Int2ObjectHashMap();
    private final MeterRegistry registry;

    public BackpressureMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void dropped(int partitionId) {
        ((Counter)this.droppedRequestCount.computeIfAbsent(partitionId, p -> this.registerCounter(BackpressureMetricsDoc.DROPPED_REQUEST_COUNT, String.valueOf(partitionId)))).increment();
    }

    public void receivedRequest(int partitionId) {
        ((Counter)this.totalRequestCount.computeIfAbsent(partitionId, p -> this.registerCounter(BackpressureMetricsDoc.TOTAL_REQUEST_COUNT, String.valueOf(partitionId)))).increment();
    }

    private Counter registerCounter(BackpressureMetricsDoc meterDoc, String partitionTag) {
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), partitionTag).register(this.registry);
    }
}

