/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.transport.backpressure.RateLimitMetrics;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandRateLimiter
extends AbstractLimiter<Intent>
implements RequestLimiter<Intent> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.broker.transport.backpressure");
    private static final Set<? extends Intent> WHITE_LISTED_COMMANDS = Set.of(JobIntent.COMPLETE, JobIntent.FAIL, ProcessInstanceIntent.CANCEL, DeploymentIntent.CREATE, DeploymentIntent.DISTRIBUTE, DeploymentDistributionIntent.COMPLETE, CommandDistributionIntent.ACKNOWLEDGE);
    private final Map<ListenerId, Limiter.Listener> responseListeners = new ConcurrentHashMap<ListenerId, Limiter.Listener>();
    private final RateLimitMetrics metrics;

    private CommandRateLimiter(CommandRateLimiterBuilder builder, RateLimitMetrics metrics) {
        super((AbstractLimiter.Builder)builder);
        this.metrics = metrics;
        metrics.setInflight(0);
        metrics.setNewLimit(this.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Limiter.Listener> acquire(Intent intent) {
        if (WHITE_LISTED_COMMANDS.contains(intent)) {
            return Optional.of(this.createListener());
        }
        CommandRateLimiter commandRateLimiter = this;
        synchronized (commandRateLimiter) {
            if (this.getInflight() < this.getLimit()) {
                return Optional.of(this.createListener());
            }
        }
        return this.createRejectedListener();
    }

    private void registerListener(int streamId, long requestId, Limiter.Listener listener) {
        this.responseListeners.put(new ListenerId(streamId, requestId), listener);
    }

    @Override
    public boolean tryAcquire(int streamId, long requestId, Intent context) {
        Optional<Limiter.Listener> acquired = this.acquire(context);
        return acquired.map(listener -> {
            this.registerListener(streamId, requestId, (Limiter.Listener)listener);
            this.metrics.incInflight();
            return true;
        }).orElse(false);
    }

    @Override
    public void onResponse(int streamId, long requestId) {
        Limiter.Listener listener = this.responseListeners.remove(new ListenerId(streamId, requestId));
        if (listener != null) {
            try {
                listener.onSuccess();
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not register request RTT (likely caused by clock problems). Consider using the 'fixed' backpressure algorithm.", (Throwable)e);
                listener.onIgnore();
            }
            this.metrics.decInflight();
        } else {
            Loggers.TRANSPORT_LOGGER.trace("Expected to have a rate limiter listener for request-{}-{}, but none found. (This can happen during fail over.)", (Object)streamId, (Object)requestId);
        }
    }

    @Override
    public void onIgnore(int streamId, long requestId) {
        Limiter.Listener listener = this.responseListeners.remove(new ListenerId(streamId, requestId));
        if (listener != null) {
            listener.onIgnore();
            this.metrics.decInflight();
        }
    }

    @Override
    public int getInflightCount() {
        return this.getInflight();
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setNewLimit(newLimit);
    }

    public static CommandRateLimiterBuilder builder() {
        return new CommandRateLimiterBuilder();
    }

    static class ListenerId {
        private final int streamId;
        private final long requestId;

        ListenerId(int streamId, long requestId) {
            this.streamId = streamId;
            this.requestId = requestId;
        }

        public int hashCode() {
            return Objects.hash(this.streamId, this.requestId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerId that = (ListenerId)o;
            return this.streamId == that.streamId && this.requestId == that.requestId;
        }
    }

    public static class CommandRateLimiterBuilder
    extends AbstractLimiter.Builder<CommandRateLimiterBuilder> {
        protected CommandRateLimiterBuilder self() {
            return this;
        }

        public CommandRateLimiter build(MeterRegistry meterRegistry, int partitionId) {
            return new CommandRateLimiter(this, new RateLimitMetrics(meterRegistry, partitionId));
        }
    }
}

