/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import io.camunda.zeebe.broker.transport.backpressure.BackpressureMetricsDoc;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;

final class RateLimitMetrics {
    private final AtomicInteger currentInflight = new AtomicInteger();
    private final AtomicInteger currentLimit = new AtomicInteger();

    RateLimitMetrics(MeterRegistry registry, int partitionId) {
        String partitionTagValue = String.valueOf(partitionId);
        Gauge.builder((String)BackpressureMetricsDoc.CURRENT_INFLIGHT.getName(), (Object)this.currentInflight, AtomicInteger::intValue).description(BackpressureMetricsDoc.CURRENT_INFLIGHT.getDescription()).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), partitionTagValue).register(registry);
        Gauge.builder((String)BackpressureMetricsDoc.CURRENT_LIMIT.getName(), (Object)this.currentLimit, AtomicInteger::intValue).description(BackpressureMetricsDoc.CURRENT_LIMIT.getDescription()).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), partitionTagValue).register(registry);
    }

    public void incInflight() {
        this.currentInflight.incrementAndGet();
    }

    public void decInflight() {
        this.currentInflight.decrementAndGet();
    }

    public void setNewLimit(int newLimit) {
        this.currentLimit.set(newLimit);
    }

    public void setInflight(int count) {
        this.currentInflight.set(count);
    }
}

