/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.future.ActorFuture;

public class CommandApiServiceTransitionStep
implements PartitionTransitionStep {
    @Override
    public void onNewRaftRole(PartitionTransitionContext context, RaftServer.Role newRole) {
    }

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        return switch (targetRole) {
            case RaftServer.Role.LEADER -> context.getConcurrencyControl().createCompletedFuture();
            default -> context.getCommandApiService().unregisterHandlers(context.getPartitionId());
        };
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        return switch (targetRole) {
            case RaftServer.Role.LEADER -> context.getCommandApiService().registerHandlers(context.getPartitionId(), context.getLogStream(), context.getQueryService());
            default -> context.getConcurrencyControl().createCompletedFuture();
        };
    }

    @Override
    public String getName() {
        return "CommandApiService";
    }
}

