/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.ConsoleOutputReportEventListener;

public final class ZeebeConsoleOutputFileReporter
implements ConsoleOutputReportEventListener {
    private static final Pattern RUN_COUNT_MATCHER = Pattern.compile("^.+?-(\\d)-output\\.txt$");
    private static final String OUTPUT_FILE_EXTENSION = "-output.txt";
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final boolean usePhrasedFileName;
    private final Integer forkNumber;
    private final ConsoleOutputReportEventListener delegate;
    private volatile String reportEntryName;

    public ZeebeConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix, boolean usePhrasedFileName, Integer forkNumber, ConsoleOutputReportEventListener delegate) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.usePhrasedFileName = usePhrasedFileName;
        this.forkNumber = forkNumber;
        this.delegate = delegate;
    }

    public synchronized void testSetStarting(TestSetReportEntry reportEntry) {
        this.reportEntryName = this.usePhrasedFileName ? reportEntry.getSourceText() : reportEntry.getSourceName();
        this.delegate.testSetStarting(reportEntry);
    }

    public synchronized void testSetCompleted(TestSetReportEntry report) {
        this.delegate.testSetStarting(report);
    }

    public synchronized void close() {
        this.delegate.close();
    }

    public synchronized void writeTestOutput(TestOutputReportEntry reportEntry) {
        try {
            Path reportPath = this.getReportPath();
            String fileName = reportPath.getFileName().toString().replace(OUTPUT_FILE_EXTENSION, "");
            Path backupPath = reportPath.resolveSibling(fileName + "-" + this.computeRunCount(reportPath, fileName) + OUTPUT_FILE_EXTENSION);
            this.delegate.writeTestOutput(reportEntry);
            if (Files.exists(reportPath, new LinkOption[0])) {
                Files.move(reportPath, backupPath, new CopyOption[0]);
            }
        }
        catch (Exception e) {
            this.dumpException(e);
            this.sneakyThrow(e);
        }
    }

    private void dumpException(Exception e) {
        if (this.forkNumber == null) {
            InPluginProcessDumpSingleton.getSingleton().dumpException((Throwable)e, e.getLocalizedMessage(), this.reportsDirectory);
        } else {
            InPluginProcessDumpSingleton.getSingleton().dumpException((Throwable)e, e.getLocalizedMessage(), this.reportsDirectory, this.forkNumber.intValue());
        }
    }

    private int computeRunCount(Path path, String fileName) throws IOException {
        Path directory = path.getParent();
        int latestRunCount = 0;
        try (DirectoryStream<Path> files = Files.newDirectoryStream(directory, p -> this.filterTestOutputFiles(fileName, (Path)p));){
            for (Path file : files) {
                Matcher matcher = RUN_COUNT_MATCHER.matcher(file.getFileName().toString());
                if (!matcher.find()) continue;
                String runCount = matcher.group(1);
                latestRunCount = Math.max(latestRunCount, Integer.parseInt(runCount));
            }
        }
        return latestRunCount + 1;
    }

    private Path getReportPath() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method delegate = FileReporter.class.getDeclaredMethod("getReportFile", File.class, String.class, String.class, String.class);
        delegate.setAccessible(true);
        File file = (File)delegate.invoke(null, this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, OUTPUT_FILE_EXTENSION);
        return file.toPath();
    }

    private boolean filterTestOutputFiles(String fileName, Path path) {
        return path.getFileName().toString().startsWith(fileName) && path.getFileName().toString().endsWith(OUTPUT_FILE_EXTENSION);
    }

    private <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

