/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.oauth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.camunda.zeebe.client.impl.ZeebeClientCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class OAuthCredentialsCache {
    private static final String KEY_AUTH = "auth";
    private static final String KEY_CREDENTIALS = "credentials";
    private static final TypeReference<Map<String, OAuthCachedCredentials>> TYPE_REFERENCE = new TypeReference<Map<String, OAuthCachedCredentials>>(){};
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Map<String, OAuthCachedCredentials> audiences;
    private final File cacheFile;

    public OAuthCredentialsCache(File cacheFile) {
        this.cacheFile = cacheFile;
        this.audiences = new HashMap<String, OAuthCachedCredentials>();
    }

    public OAuthCredentialsCache readCache() throws IOException {
        if (!this.cacheFile.exists() || this.cacheFile.length() == 0L) {
            return this;
        }
        Map cache = (Map)MAPPER.readValue(this.cacheFile, TYPE_REFERENCE);
        this.audiences.clear();
        this.audiences.putAll(cache);
        return this;
    }

    public void writeCache() throws IOException {
        HashMap<String, Map<String, OAuthCachedCredentials>> cache = new HashMap<String, Map<String, OAuthCachedCredentials>>(this.audiences.size());
        for (Map.Entry<String, OAuthCachedCredentials> audience : this.audiences.entrySet()) {
            cache.put(audience.getKey(), Collections.singletonMap(KEY_AUTH, audience.getValue()));
        }
        this.ensureCacheFileExists();
        MAPPER.writer().writeValue(this.cacheFile, cache);
    }

    public Optional<ZeebeClientCredentials> get(String endpoint) {
        return Optional.ofNullable(this.audiences.get(endpoint)).map(rec$ -> ((OAuthCachedCredentials)rec$).getCredentials());
    }

    public OAuthCredentialsCache put(String endpoint, ZeebeClientCredentials credentials) {
        this.audiences.put(endpoint, new OAuthCachedCredentials(credentials));
        return this;
    }

    public int size() {
        return this.audiences.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureCacheFileExists() throws IOException {
        if (this.cacheFile.exists()) {
            return;
        }
        File parentDirectory = this.cacheFile.getParentFile();
        if (parentDirectory.exists()) {
            if (!parentDirectory.isDirectory()) {
                if (!Files.isSymbolicLink(parentDirectory.toPath())) throw new IOException("Expected " + parentDirectory.getAbsolutePath() + " to be a directory, but it was a regular file.");
                this.requireSymbolicLinkPointsToDirectory(parentDirectory);
            }
        } else if (Files.isSymbolicLink(parentDirectory.toPath())) {
            this.requireSymbolicLinkPointsToDirectory(parentDirectory);
        } else {
            Files.createDirectories(parentDirectory.toPath(), new FileAttribute[0]);
        }
        Files.createFile(this.cacheFile.toPath(), new FileAttribute[0]);
    }

    private void requireSymbolicLinkPointsToDirectory(File file) throws IOException {
        Path resolvedPath = Files.readSymbolicLink(file.toPath());
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            if (!Files.isDirectory(resolvedPath, new LinkOption[0])) {
                throw new IOException("Expected " + file.getAbsolutePath() + " to be a directory, but it was a symbolic link pointing to a regular file.");
            }
        } else {
            throw new IOException("Expected " + file.getAbsolutePath() + " to be a directory, but it was a symbolic link to unresolvable path.");
        }
    }

    private static final class OAuthCachedCredentials {
        private final ZeebeClientCredentials credentials;

        @JsonCreator
        private OAuthCachedCredentials(@JsonProperty(value="auth") Map<String, ZeebeClientCredentials> auth) {
            this(auth.get(OAuthCredentialsCache.KEY_CREDENTIALS));
        }

        private OAuthCachedCredentials(ZeebeClientCredentials credentials) {
            this.credentials = credentials;
        }

        @JsonGetter(value="credentials")
        private ZeebeClientCredentials getCredentials() {
            return this.credentials;
        }
    }
}

