/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.oauth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.camunda.zeebe.client.impl.ZeebeClientCredentials;
import io.camunda.zeebe.client.impl.util.FunctionWithIO;
import io.camunda.zeebe.client.impl.util.SupplierWithIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OAuthCredentialsCache {
    private static final String KEY_AUTH = "auth";
    private static final String KEY_CREDENTIALS = "credentials";
    private static final TypeReference<Map<String, OAuthCachedCredentials>> TYPE_REFERENCE = new TypeReference<Map<String, OAuthCachedCredentials>>(){};
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ReentrantReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock READ_LOCK = READ_WRITE_LOCK.readLock();
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = READ_WRITE_LOCK.writeLock();
    private final File cacheFile;
    private final AtomicReference<Map<String, OAuthCachedCredentials>> audiences;

    public OAuthCredentialsCache(File cacheFile) {
        this.cacheFile = cacheFile;
        this.audiences = new AtomicReference(new HashMap());
    }

    public OAuthCredentialsCache readCache() throws IOException {
        READ_LOCK.lock();
        try {
            if (!this.cacheFile.exists() || this.cacheFile.length() == 0L) {
                OAuthCredentialsCache oAuthCredentialsCache = this;
                return oAuthCredentialsCache;
            }
            Map cache = (Map)MAPPER.readValue(this.cacheFile, TYPE_REFERENCE);
            this.audiences.set(cache);
        }
        finally {
            READ_LOCK.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCache() throws IOException {
        Map<String, OAuthCachedCredentials> values = this.audiences.get();
        HashMap<String, Map<String, OAuthCachedCredentials>> cache = new HashMap<String, Map<String, OAuthCachedCredentials>>(values.size());
        for (Map.Entry<String, OAuthCachedCredentials> audience : values.entrySet()) {
            cache.put(audience.getKey(), Collections.singletonMap(KEY_AUTH, audience.getValue()));
        }
        WRITE_LOCK.lock();
        try {
            this.ensureCacheFileExists();
            MAPPER.writer().writeValue(this.cacheFile, cache);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public Optional<ZeebeClientCredentials> get(String endpoint) {
        Map<String, OAuthCachedCredentials> cache = this.audiences.get();
        return Optional.ofNullable(cache.get(endpoint)).map(rec$ -> ((OAuthCachedCredentials)rec$).getCredentials());
    }

    public synchronized ZeebeClientCredentials computeIfMissingOrInvalid(String endpoint, SupplierWithIO<ZeebeClientCredentials> zeebeClientCredentialsConsumer) throws IOException {
        Optional optionalCredentials = this.readCache().get(endpoint).flatMap(zeebeClientCredentials -> {
            if (!zeebeClientCredentials.isValid()) {
                return Optional.empty();
            }
            return Optional.of(zeebeClientCredentials);
        });
        if (optionalCredentials.isPresent()) {
            return (ZeebeClientCredentials)optionalCredentials.get();
        }
        ZeebeClientCredentials credentials = zeebeClientCredentialsConsumer.get();
        this.put(endpoint, credentials).writeCache();
        return credentials;
    }

    public <T> Optional<T> withCache(String endpoint, FunctionWithIO<ZeebeClientCredentials, T> function) throws IOException {
        Optional<ZeebeClientCredentials> optionalCredentials = this.readCache().get(endpoint);
        if (optionalCredentials.isPresent()) {
            return Optional.ofNullable(function.apply(optionalCredentials.get()));
        }
        return Optional.empty();
    }

    public OAuthCredentialsCache put(String endpoint, ZeebeClientCredentials credentials) {
        this.audiences.getAndUpdate(current -> {
            HashMap<String, OAuthCachedCredentials> cache = new HashMap<String, OAuthCachedCredentials>((Map<String, OAuthCachedCredentials>)current);
            cache.put(endpoint, new OAuthCachedCredentials(credentials));
            return cache;
        });
        return this;
    }

    public int size() {
        return this.audiences.get().size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureCacheFileExists() throws IOException {
        if (this.cacheFile.exists()) {
            return;
        }
        File parentDirectory = this.cacheFile.getParentFile();
        if (parentDirectory.exists()) {
            if (!parentDirectory.isDirectory()) {
                if (!Files.isSymbolicLink(parentDirectory.toPath())) throw new IOException("Expected " + parentDirectory.getAbsolutePath() + " to be a directory, but it was a regular file.");
                this.requireSymbolicLinkPointsToDirectory(parentDirectory);
            }
        } else if (Files.isSymbolicLink(parentDirectory.toPath())) {
            this.requireSymbolicLinkPointsToDirectory(parentDirectory);
        } else {
            Files.createDirectories(parentDirectory.toPath(), new FileAttribute[0]);
        }
        Files.createFile(this.cacheFile.toPath(), new FileAttribute[0]);
    }

    private void requireSymbolicLinkPointsToDirectory(File file) throws IOException {
        Path resolvedPath = Files.readSymbolicLink(file.toPath());
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            if (!Files.isDirectory(resolvedPath, new LinkOption[0])) {
                throw new IOException("Expected " + file.getAbsolutePath() + " to be a directory, but it was a symbolic link pointing to a regular file.");
            }
        } else {
            throw new IOException("Expected " + file.getAbsolutePath() + " to be a directory, but it was a symbolic link to unresolvable path.");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class OAuthCachedCredentials {
        private final ZeebeClientCredentials credentials;

        @JsonCreator
        private OAuthCachedCredentials(@JsonProperty(value="auth") Map<String, ZeebeClientCredentials> auth) {
            this(auth.get(OAuthCredentialsCache.KEY_CREDENTIALS));
        }

        private OAuthCachedCredentials(ZeebeClientCredentials credentials) {
            this.credentials = credentials;
        }

        @JsonGetter(value="credentials")
        private ZeebeClientCredentials getCredentials() {
            return this.credentials;
        }
    }
}

