/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.BuilderUtils;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.DataSizeUtil;
import io.camunda.zeebe.client.impl.util.Environment;
import io.grpc.ClientInterceptor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;

public final class ZeebeClientBuilderImpl
implements ZeebeClientBuilder,
ZeebeClientConfiguration {
    public static final String PLAINTEXT_CONNECTION_VAR = "ZEEBE_INSECURE_CONNECTION";
    public static final String CA_CERTIFICATE_VAR = "ZEEBE_CA_CERTIFICATE_PATH";
    public static final String KEEP_ALIVE_VAR = "ZEEBE_KEEP_ALIVE";
    public static final String OVERRIDE_AUTHORITY_VAR = "ZEEBE_OVERRIDE_AUTHORITY";
    public static final String ZEEBE_CLIENT_WORKER_STREAM_ENABLED = "ZEEBE_CLIENT_WORKER_STREAM_ENABLED";
    public static final String DEFAULT_GATEWAY_ADDRESS = "0.0.0.0:26500";
    public static final String DEFAULT_TENANT_ID_VAR = "ZEEBE_DEFAULT_TENANT_ID";
    public static final String DEFAULT_JOB_WORKER_TENANT_IDS_VAR = "ZEEBE_DEFAULT_JOB_WORKER_TENANT_IDS";
    public static final String DEFAULT_JOB_WORKER_NAME = "default";
    private static final String TENANT_ID_LIST_SEPARATOR = ",";
    private boolean applyEnvironmentVariableOverrides = true;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private String gatewayAddress = "0.0.0.0:26500";
    private String defaultTenantId = "<default>";
    private List<String> defaultJobWorkerTenantIds = Collections.singletonList("<default>");
    private int jobWorkerMaxJobsActive = 32;
    private int numJobWorkerExecutionThreads = 1;
    private String defaultJobWorkerName = "default";
    private Duration defaultJobTimeout = Duration.ofMinutes(5L);
    private Duration defaultJobPollInterval = Duration.ofMillis(100L);
    private Duration defaultMessageTimeToLive = Duration.ofHours(1L);
    private Duration defaultRequestTimeout = Duration.ofSeconds(10L);
    private boolean usePlaintextConnection = false;
    private String certificatePath;
    private CredentialsProvider credentialsProvider;
    private Duration keepAlive = Duration.ofSeconds(45L);
    private JsonMapper jsonMapper = new ZeebeObjectMapper();
    private String overrideAuthority;
    private int maxMessageSize = 0x400000;
    private int maxMetadataSize = 16384;
    private boolean streamEnabled = false;
    private ScheduledExecutorService jobWorkerExecutor;
    private boolean ownsJobWorkerExecutor;

    @Override
    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    @Override
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    @Override
    public List<String> getDefaultJobWorkerTenantIds() {
        return this.defaultJobWorkerTenantIds;
    }

    @Override
    public int getNumJobWorkerExecutionThreads() {
        return this.numJobWorkerExecutionThreads;
    }

    @Override
    public int getDefaultJobWorkerMaxJobsActive() {
        return this.jobWorkerMaxJobsActive;
    }

    @Override
    public String getDefaultJobWorkerName() {
        return this.defaultJobWorkerName;
    }

    @Override
    public Duration getDefaultJobTimeout() {
        return this.defaultJobTimeout;
    }

    @Override
    public Duration getDefaultJobPollInterval() {
        return this.defaultJobPollInterval;
    }

    @Override
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    @Override
    public Duration getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    @Override
    public boolean isPlaintextConnectionEnabled() {
        return this.usePlaintextConnection;
    }

    @Override
    public String getCaCertificatePath() {
        return this.certificatePath;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public int getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    @Override
    public ScheduledExecutorService jobWorkerExecutor() {
        return this.jobWorkerExecutor;
    }

    @Override
    public boolean ownsJobWorkerExecutor() {
        return this.ownsJobWorkerExecutor;
    }

    @Override
    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.streamEnabled;
    }

    @Override
    public ZeebeClientBuilder withProperties(Properties properties) {
        if (properties.containsKey("zeebe.client.applyEnvironmentVariableOverrides")) {
            this.applyEnvironmentVariableOverrides(Boolean.parseBoolean(properties.getProperty("zeebe.client.applyEnvironmentVariableOverrides")));
        }
        if (properties.containsKey("zeebe.client.gateway.address")) {
            this.gatewayAddress(properties.getProperty("zeebe.client.gateway.address"));
        }
        if (properties.containsKey("zeebe.client.tenantId")) {
            this.defaultTenantId(properties.getProperty("zeebe.client.tenantId"));
        }
        if (properties.containsKey("zeebe.client.worker.tenantIds")) {
            String tenantIdsList = properties.getProperty("zeebe.client.worker.tenantIds");
            List<String> tenantIds = Arrays.asList(tenantIdsList.split(TENANT_ID_LIST_SEPARATOR));
            this.defaultJobWorkerTenantIds(tenantIds);
        }
        if (properties.containsKey("zeebe.client.worker.threads")) {
            this.numJobWorkerExecutionThreads(Integer.parseInt(properties.getProperty("zeebe.client.worker.threads")));
        }
        if (properties.containsKey("zeebe.client.worker.maxJobsActive")) {
            this.defaultJobWorkerMaxJobsActive(Integer.parseInt(properties.getProperty("zeebe.client.worker.maxJobsActive")));
        }
        if (properties.containsKey("zeebe.client.worker.name")) {
            this.defaultJobWorkerName(properties.getProperty("zeebe.client.worker.name"));
        }
        if (properties.containsKey("zeebe.client.job.timeout")) {
            this.defaultJobTimeout(Duration.ofMillis(Integer.parseInt(properties.getProperty("zeebe.client.job.timeout"))));
        }
        if (properties.containsKey("zeebe.client.job.pollinterval")) {
            this.defaultJobPollInterval(Duration.ofMillis(Integer.parseInt(properties.getProperty("zeebe.client.job.pollinterval"))));
        }
        if (properties.containsKey("zeebe.client.message.timeToLive")) {
            this.defaultMessageTimeToLive(Duration.ofMillis(Long.parseLong(properties.getProperty("zeebe.client.message.timeToLive"))));
        }
        if (properties.containsKey("zeebe.client.requestTimeout")) {
            this.defaultRequestTimeout(Duration.ofMillis(Long.parseLong(properties.getProperty("zeebe.client.requestTimeout"))));
        }
        if (properties.containsKey("zeebe.client.security.plaintext") && !"false".equalsIgnoreCase(properties.getProperty("zeebe.client.security.plaintext"))) {
            this.usePlaintext();
        }
        if (properties.containsKey("zeebe.client.security.certpath")) {
            this.caCertificatePath(properties.getProperty("zeebe.client.security.certpath"));
        }
        if (properties.containsKey("zeebe.client.keepalive")) {
            this.keepAlive(properties.getProperty("zeebe.client.keepalive"));
        }
        if (properties.containsKey("zeebe.client.overrideauthority")) {
            this.overrideAuthority(properties.getProperty("zeebe.client.overrideauthority"));
        }
        if (properties.containsKey("zeebe.client.maxMessageSize")) {
            this.maxMessageSize(DataSizeUtil.parse(properties.getProperty("zeebe.client.maxMessageSize")));
        }
        if (properties.containsKey("zeebe.client.maxMetadataSize")) {
            this.maxMetadataSize(DataSizeUtil.parse(properties.getProperty("zeebe.client.maxMetadataSize")));
        }
        if (properties.containsKey("zeebe.client.worker.stream.enabled")) {
            this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(properties.getProperty("zeebe.client.worker.stream.enabled")));
        }
        return this;
    }

    @Override
    public ZeebeClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.applyEnvironmentVariableOverrides = applyEnvironmentVariableOverrides;
        return this;
    }

    @Override
    public ZeebeClientBuilder gatewayAddress(String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultTenantId(String tenantId) {
        this.defaultTenantId = tenantId;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        this.defaultJobWorkerTenantIds = tenantIds;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.jobWorkerMaxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public ZeebeClientBuilder numJobWorkerExecutionThreads(int numSubscriptionThreads) {
        this.numJobWorkerExecutionThreads = numSubscriptionThreads;
        return this;
    }

    @Override
    public ZeebeClientBuilder jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.jobWorkerExecutor = executor;
        this.ownsJobWorkerExecutor = takeOwnership;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerName(String workerName) {
        if (workerName != null) {
            this.defaultJobWorkerName = workerName;
        }
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobTimeout(Duration timeout) {
        this.defaultJobTimeout = timeout;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.defaultJobPollInterval = pollInterval;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.defaultMessageTimeToLive = timeToLive;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.defaultRequestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeClientBuilder usePlaintext() {
        this.usePlaintextConnection = true;
        return this;
    }

    @Override
    public ZeebeClientBuilder caCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    @Override
    public ZeebeClientBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    @Override
    public ZeebeClientBuilder keepAlive(Duration keepAlive) {
        if (keepAlive.isNegative() || keepAlive.isZero()) {
            throw new IllegalArgumentException("The keep alive must be a positive number.");
        }
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public ZeebeClientBuilder withInterceptors(ClientInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    @Override
    public ZeebeClientBuilder withJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    @Override
    public ZeebeClientBuilder overrideAuthority(String authority) {
        this.overrideAuthority = authority;
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMetadataSize(int maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.streamEnabled = streamEnabled;
        return this;
    }

    @Override
    public ZeebeClient build() {
        if (this.applyEnvironmentVariableOverrides) {
            this.applyOverrides();
        }
        return new ZeebeClientImpl(this);
    }

    private void keepAlive(String keepAlive) {
        this.keepAlive(Duration.ofMillis(Long.parseUnsignedLong(keepAlive)));
    }

    private void applyOverrides() {
        if (Environment.system().isDefined(PLAINTEXT_CONNECTION_VAR)) {
            this.usePlaintextConnection = Environment.system().getBoolean(PLAINTEXT_CONNECTION_VAR);
        }
        if (Environment.system().isDefined(CA_CERTIFICATE_VAR)) {
            this.caCertificatePath(Environment.system().get(CA_CERTIFICATE_VAR));
        }
        if (Environment.system().isDefined(KEEP_ALIVE_VAR)) {
            this.keepAlive(Environment.system().get(KEEP_ALIVE_VAR));
        }
        if (Environment.system().isDefined(OVERRIDE_AUTHORITY_VAR)) {
            this.overrideAuthority(Environment.system().get(OVERRIDE_AUTHORITY_VAR));
        }
        if (this.shouldUseDefaultCredentialsProvider()) {
            this.credentialsProvider = this.createDefaultCredentialsProvider();
        }
        if (Environment.system().isDefined("zeebe.client.maxMessageSize")) {
            this.maxMessageSize(DataSizeUtil.parse(Environment.system().get("zeebe.client.maxMessageSize")));
        }
        if (Environment.system().isDefined("zeebe.client.maxMetadataSize")) {
            this.maxMetadataSize(DataSizeUtil.parse(Environment.system().get("zeebe.client.maxMetadataSize")));
        }
        if (Environment.system().isDefined(DEFAULT_TENANT_ID_VAR)) {
            this.defaultTenantId(Environment.system().get(DEFAULT_TENANT_ID_VAR));
        }
        if (Environment.system().isDefined(DEFAULT_JOB_WORKER_TENANT_IDS_VAR)) {
            String tenantIdsList = Environment.system().get(DEFAULT_JOB_WORKER_TENANT_IDS_VAR);
            List<String> tenantIds = Arrays.asList(tenantIdsList.split(TENANT_ID_LIST_SEPARATOR));
            this.defaultJobWorkerTenantIds(tenantIds);
        }
        if (Environment.system().isDefined(ZEEBE_CLIENT_WORKER_STREAM_ENABLED)) {
            this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(Environment.system().get(ZEEBE_CLIENT_WORKER_STREAM_ENABLED)));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        BuilderUtils.appendProperty(sb, "gatewayAddress", this.gatewayAddress);
        BuilderUtils.appendProperty(sb, "defaultTenantId", this.defaultTenantId);
        BuilderUtils.appendProperty(sb, "jobWorkerMaxJobsActive", this.jobWorkerMaxJobsActive);
        BuilderUtils.appendProperty(sb, "numJobWorkerExecutionThreads", this.numJobWorkerExecutionThreads);
        BuilderUtils.appendProperty(sb, "defaultJobWorkerName", this.defaultJobWorkerName);
        BuilderUtils.appendProperty(sb, "defaultJobTimeout", this.defaultJobTimeout);
        BuilderUtils.appendProperty(sb, "defaultJobPollInterval", this.defaultJobPollInterval);
        BuilderUtils.appendProperty(sb, "defaultMessageTimeToLive", this.defaultMessageTimeToLive);
        BuilderUtils.appendProperty(sb, "defaultRequestTimeout", this.defaultRequestTimeout);
        BuilderUtils.appendProperty(sb, "overrideAuthority", this.overrideAuthority);
        BuilderUtils.appendProperty(sb, "maxMessageSize", this.maxMessageSize);
        BuilderUtils.appendProperty(sb, "maxMetadataSize", this.maxMetadataSize);
        BuilderUtils.appendProperty(sb, "jobWorkerExecutor", this.jobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "ownsJobWorkerExecutor", this.ownsJobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "streamEnabled", this.streamEnabled);
        return sb.toString();
    }

    private boolean shouldUseDefaultCredentialsProvider() {
        return this.credentialsProvider == null && Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null;
    }

    private CredentialsProvider createDefaultCredentialsProvider() {
        OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
        int separatorIndex = this.gatewayAddress.lastIndexOf(58);
        if (separatorIndex > 0) {
            builder.audience(this.gatewayAddress.substring(0, separatorIndex));
        }
        return builder.build();
    }
}

