/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.Decision;
import io.camunda.zeebe.client.api.response.DecisionRequirements;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.Form;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.response.DecisionImpl;
import io.camunda.zeebe.client.impl.response.DecisionRequirementsImpl;
import io.camunda.zeebe.client.impl.response.FormImpl;
import io.camunda.zeebe.client.impl.response.ProcessImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class DeploymentEventImpl
implements DeploymentEvent {
    private static final Logger LOG = Loggers.LOGGER;
    private static final String UNKNOWN_METADATA_WARN_MSG = "Expected metadata in deployment response, but encountered an unknown type of metadata. This might happen when you've updated your Zeebe cluster, but not your Zeebe client. You may have to update the version of your zeebe-client-java dependency to resolve the issue.";
    private final long key;
    private final String tenantId;
    private final List<Process> processes = new ArrayList<Process>();
    private final List<Decision> decisions = new ArrayList<Decision>();
    private final List<DecisionRequirements> decisionRequirements = new ArrayList<DecisionRequirements>();
    private final List<Form> forms = new ArrayList<Form>();

    public DeploymentEventImpl(GatewayOuterClass.DeployProcessResponse response) {
        this.key = response.getKey();
        this.tenantId = "<default>";
        response.getProcessesList().stream().map(ProcessImpl::new).forEach(this.processes::add);
    }

    public DeploymentEventImpl(GatewayOuterClass.DeployResourceResponse response) {
        this.key = response.getKey();
        this.tenantId = response.getTenantId();
        block6: for (GatewayOuterClass.Deployment deployment : response.getDeploymentsList()) {
            switch (deployment.getMetadataCase()) {
                case PROCESS: {
                    this.processes.add(new ProcessImpl(deployment.getProcess()));
                    continue block6;
                }
                case DECISION: {
                    this.decisions.add(new DecisionImpl(deployment.getDecision()));
                    continue block6;
                }
                case DECISIONREQUIREMENTS: {
                    this.decisionRequirements.add(new DecisionRequirementsImpl(deployment.getDecisionRequirements()));
                    continue block6;
                }
                case FORM: {
                    this.forms.add(new FormImpl(deployment.getForm()));
                    continue block6;
                }
            }
            LOG.warn(UNKNOWN_METADATA_WARN_MSG);
        }
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public List<Process> getProcesses() {
        return this.processes;
    }

    @Override
    public List<Decision> getDecisions() {
        return this.decisions;
    }

    @Override
    public List<DecisionRequirements> getDecisionRequirements() {
        return this.decisionRequirements;
    }

    @Override
    public List<Form> getForm() {
        return this.forms;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return "DeploymentEventImpl{key=" + this.key + ", processes=" + this.processes + ", decisions=" + this.decisions + ", decisionRequirements=" + this.decisionRequirements + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

