/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class BlockingExecutor {
    public static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final Executor wrappedExecutor;
    private final Semaphore semaphore;
    private final long timeoutMillis;

    public BlockingExecutor(Executor wrappedExecutor, int maxActivate, Duration jobActivationTimeout) {
        this.wrappedExecutor = wrappedExecutor;
        this.semaphore = new Semaphore(maxActivate);
        this.timeoutMillis = jobActivationTimeout.toMillis();
    }

    public void execute(Runnable command) throws RejectedExecutionException {
        try {
            if (!this.semaphore.tryAcquire(this.timeoutMillis, TIMEOUT_UNIT)) {
                throw new RejectedExecutionException(String.format("Not able to acquire lease in %d%s", this.timeoutMillis, TIMEOUT_UNIT.toString()));
            }
            this.wrappedExecutor.execute(() -> {
                try {
                    command.run();
                }
                finally {
                    this.semaphore.release();
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

