/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.client.api.worker.JobWorkerMetrics;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.worker.JobPollerImpl;
import io.camunda.zeebe.client.impl.worker.JobRunnableFactoryImpl;
import io.camunda.zeebe.client.impl.worker.JobStreamer;
import io.camunda.zeebe.client.impl.worker.JobStreamerImpl;
import io.camunda.zeebe.client.impl.worker.JobWorkerImpl;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public final class JobWorkerBuilderImpl
implements JobWorkerBuilderStep1,
JobWorkerBuilderStep1.JobWorkerBuilderStep2,
JobWorkerBuilderStep1.JobWorkerBuilderStep3 {
    public static final BackoffSupplier DEFAULT_BACKOFF_SUPPLIER = BackoffSupplier.newBackoffBuilder().build();
    public static final Duration DEFAULT_STREAMING_TIMEOUT = Duration.ofHours(8L);
    private final JobClient jobClient;
    private final ScheduledExecutorService executorService;
    private final List<Closeable> closeables;
    private String jobType;
    private JobHandler handler;
    private Duration timeout;
    private String workerName;
    private int maxJobsActive;
    private Duration pollInterval;
    private Duration requestTimeout;
    private List<String> fetchVariables;
    private final List<String> defaultTenantIds;
    private final List<String> customTenantIds;
    private BackoffSupplier backoffSupplier;
    private boolean enableStreaming;
    private Duration streamingTimeout;
    private JobWorkerMetrics metrics = JobWorkerMetrics.noop();

    public JobWorkerBuilderImpl(ZeebeClientConfiguration configuration, JobClient jobClient, ScheduledExecutorService executorService, List<Closeable> closeables) {
        this.jobClient = jobClient;
        this.executorService = executorService;
        this.closeables = closeables;
        this.timeout = configuration.getDefaultJobTimeout();
        this.workerName = configuration.getDefaultJobWorkerName();
        this.maxJobsActive = configuration.getDefaultJobWorkerMaxJobsActive();
        this.pollInterval = configuration.getDefaultJobPollInterval();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
        this.enableStreaming = configuration.getDefaultJobWorkerStreamEnabled();
        this.defaultTenantIds = configuration.getDefaultJobWorkerTenantIds();
        this.customTenantIds = new ArrayList<String>();
        this.backoffSupplier = DEFAULT_BACKOFF_SUPPLIER;
        this.streamingTimeout = DEFAULT_STREAMING_TIMEOUT;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep2 jobType(String type) {
        this.jobType = type;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 handler(JobHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 timeout(long timeout) {
        return this.timeout(Duration.ofMillis(timeout));
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 name(String workerName) {
        this.workerName = workerName;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 maxJobsActive(int maxJobsActive) {
        this.maxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 pollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 fetchVariables(List<String> fetchVariables) {
        this.fetchVariables = fetchVariables;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 backoffSupplier(BackoffSupplier backoffSupplier) {
        this.backoffSupplier = backoffSupplier;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 streamEnabled(boolean isStreamEnabled) {
        this.enableStreaming = isStreamEnabled;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 streamTimeout(Duration timeout) {
        this.streamingTimeout = timeout;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 metrics(JobWorkerMetrics metrics) {
        this.metrics = metrics == null ? JobWorkerMetrics.noop() : metrics;
        return this;
    }

    @Override
    public JobWorker open() {
        JobStreamer jobStreamer;
        ArgumentUtil.ensureNotNullNorEmpty("jobType", this.jobType);
        ArgumentUtil.ensureNotNull("jobHandler", this.handler);
        ArgumentUtil.ensurePositive("timeout", this.timeout);
        ArgumentUtil.ensureNotNullNorEmpty("workerName", this.workerName);
        ArgumentUtil.ensureGreaterThan("maxJobsActive", this.maxJobsActive, 0L);
        JobRunnableFactoryImpl jobRunnableFactory = new JobRunnableFactoryImpl(this.jobClient, this.handler);
        JobPollerImpl jobPoller = new JobPollerImpl(this.jobClient, this.requestTimeout, this.jobType, this.workerName, this.timeout, this.fetchVariables, this.getTenantIds(), this.maxJobsActive);
        if (this.enableStreaming) {
            if (this.streamingTimeout != null) {
                ArgumentUtil.ensurePositive("streamingTimeout", this.streamingTimeout);
            }
            jobStreamer = new JobStreamerImpl(this.jobClient, this.jobType, this.workerName, this.timeout, this.fetchVariables, this.getTenantIds(), this.streamingTimeout, this.backoffSupplier, this.executorService);
        } else {
            jobStreamer = JobStreamer.noop();
        }
        JobWorkerImpl jobWorker = new JobWorkerImpl(this.maxJobsActive, this.timeout, this.executorService, this.pollInterval, jobRunnableFactory, jobPoller, jobStreamer, this.backoffSupplier, this.metrics);
        this.closeables.add(jobWorker);
        return jobWorker;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 tenantId(String tenantId) {
        this.customTenantIds.add(tenantId);
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 tenantIds(List<String> tenantIds) {
        this.customTenantIds.addAll(tenantIds);
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 tenantIds(String ... tenantIds) {
        this.tenantIds((List)Arrays.asList(tenantIds));
        return this;
    }

    private List<String> getTenantIds() {
        return this.customTenantIds.isEmpty() ? this.defaultTenantIds : this.customTenantIds;
    }
}

