/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientCloudBuilderStep1;
import io.camunda.zeebe.client.api.ExperimentalApi;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.BuilderUtils;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.grpc.ClientInterceptor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;

public class ZeebeClientCloudBuilderImpl
implements ZeebeClientCloudBuilderStep1,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 {
    private static final String BASE_ADDRESS = "zeebe.camunda.io";
    private static final String BASE_AUTH_URL = "https://login.cloud.camunda.io/oauth/token";
    private static final String DEFAULT_REGION = "bru-2";
    private final ZeebeClientBuilderImpl innerBuilder = new ZeebeClientBuilderImpl();
    private String clusterId;
    private String clientId;
    private String clientSecret;
    private String region = "bru-2";

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2 withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3 withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withRegion(String region) {
        this.region = region;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withProperties(Properties properties) {
        if (properties.containsKey("zeebe.client.cloud.clusterId")) {
            this.withClusterId(properties.getProperty("zeebe.client.cloud.clusterId"));
        }
        if (properties.containsKey("zeebe.client.cloud.clientId")) {
            this.withClientId(properties.getProperty("zeebe.client.cloud.clientId"));
        }
        if (properties.containsKey("zeebe.client.cloud.secret")) {
            this.withClientSecret(properties.getProperty("zeebe.client.cloud.secret"));
        }
        if (properties.containsKey("zeebe.client.cloud.region")) {
            this.withRegion(properties.getProperty("zeebe.client.cloud.region"));
        }
        if (properties.containsKey("zeebe.client.worker.stream.enabled")) {
            this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(properties.getProperty("zeebe.client.worker.stream.enabled")));
        }
        this.innerBuilder.withProperties(properties);
        this.innerBuilder.defaultTenantId("");
        this.innerBuilder.defaultJobWorkerTenantIds(Collections.emptyList());
        return this;
    }

    @Override
    public ZeebeClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.innerBuilder.applyEnvironmentVariableOverrides(applyEnvironmentVariableOverrides);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 gatewayAddress(String gatewayAddress) {
        this.innerBuilder.gatewayAddress(gatewayAddress);
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/zeebe/issues/14106")
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultTenantId(String tenantId) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/zeebe/issues/14106.");
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/zeebe/issues/14106")
    public ZeebeClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/zeebe/issues/14106.");
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.innerBuilder.defaultJobWorkerMaxJobsActive(maxJobsActive);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 numJobWorkerExecutionThreads(int numThreads) {
        this.innerBuilder.numJobWorkerExecutionThreads(numThreads);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.innerBuilder.jobWorkerExecutor(executor, takeOwnership);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultJobWorkerName(String workerName) {
        this.innerBuilder.defaultJobWorkerName(workerName);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultJobTimeout(Duration timeout) {
        this.innerBuilder.defaultJobTimeout(timeout);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultJobPollInterval(Duration pollInterval) {
        this.innerBuilder.defaultJobPollInterval(pollInterval);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultMessageTimeToLive(Duration timeToLive) {
        this.innerBuilder.defaultMessageTimeToLive(timeToLive);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 defaultRequestTimeout(Duration requestTimeout) {
        this.innerBuilder.defaultRequestTimeout(requestTimeout);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 usePlaintext() {
        this.innerBuilder.usePlaintext();
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 caCertificatePath(String certificatePath) {
        this.innerBuilder.caCertificatePath(certificatePath);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 credentialsProvider(CredentialsProvider credentialsProvider) {
        this.innerBuilder.credentialsProvider(credentialsProvider);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 keepAlive(Duration keepAlive) {
        this.innerBuilder.keepAlive(keepAlive);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withInterceptors(ClientInterceptor ... interceptor) {
        this.innerBuilder.withInterceptors(interceptor);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withJsonMapper(JsonMapper jsonMapper) {
        this.innerBuilder.withJsonMapper(jsonMapper);
        return this;
    }

    @Override
    public ZeebeClientBuilder overrideAuthority(String authority) {
        this.innerBuilder.overrideAuthority(authority);
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMessageSize(int maxMessageSize) {
        this.innerBuilder.maxMessageSize(maxMessageSize);
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMetadataSize(int maxMetadataSize) {
        return this.innerBuilder.maxMetadataSize(maxMetadataSize);
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.innerBuilder.defaultJobWorkerStreamEnabled(streamEnabled);
        return this;
    }

    @Override
    public ZeebeClientBuilder useDefaultRetryPolicy(boolean useDefaultRetryPolicy) {
        this.innerBuilder.useDefaultRetryPolicy(useDefaultRetryPolicy);
        return this;
    }

    @Override
    public ZeebeClient build() {
        this.innerBuilder.gatewayAddress(this.determineGatewayAddress());
        this.innerBuilder.credentialsProvider(this.determineCredentialsProvider());
        return this.innerBuilder.build();
    }

    private String determineGatewayAddress() {
        if (this.isNeedToSetCloudGatewayAddress()) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            return String.format("%s.%s.%s:443", this.clusterId, this.region, BASE_ADDRESS);
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id' to set gateway address in the client cloud builder, but overwriting with explicitly defined gateway address: {}.", (Object)this.innerBuilder.getGatewayAddress());
        return this.innerBuilder.getGatewayAddress();
    }

    private CredentialsProvider determineCredentialsProvider() {
        CredentialsProvider provider = this.innerBuilder.getCredentialsProvider();
        if (provider == null) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            ArgumentUtil.ensureNotNull("client id", this.clientId);
            ArgumentUtil.ensureNotNull("client secret", this.clientSecret);
            OAuthCredentialsProviderBuilder builder = new OAuthCredentialsProviderBuilder();
            if (this.innerBuilder.isPlaintextConnectionEnabled()) {
                Loggers.LOGGER.debug("Expected setting 'usePlaintext' to be 'false', but found 'true'.");
            }
            return builder.audience(String.format("%s.%s.%s", this.clusterId, this.region, BASE_ADDRESS)).clientId(this.clientId).clientSecret(this.clientSecret).authorizationServerUrl(BASE_AUTH_URL).build();
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id', 'client id' and 'client secret' to set credentials provider in the client cloud builder, but overwriting with explicitly defined credentials provider.");
        return provider;
    }

    private boolean isNeedToSetCloudGatewayAddress() {
        return this.innerBuilder.getGatewayAddress() == null || Objects.equals(this.innerBuilder.getGatewayAddress(), "0.0.0.0:26500");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.innerBuilder.toString());
        BuilderUtils.appendProperty(sb, "clusterId", this.clusterId);
        BuilderUtils.appendProperty(sb, "clientId", this.clientId);
        BuilderUtils.appendProperty(sb, "region", this.region);
        return sb.toString();
    }
}

