/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.http.JsonAsyncResponseConsumer;
import io.camunda.zeebe.client.impl.http.JsonCallback;
import io.camunda.zeebe.client.impl.http.JsonResponseTransformer;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private final CloseableHttpAsyncClient client;
    private final ObjectMapper jsonMapper;
    private final URI address;
    private final RequestConfig defaultRequestConfig;
    private final int maxMessageSize;
    private final TimeValue shutdownTimeout;

    public HttpClient(CloseableHttpAsyncClient client, ObjectMapper jsonMapper, URI address, RequestConfig defaultRequestConfig, int maxMessageSize, TimeValue shutdownTimeout) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.address = address;
        this.defaultRequestConfig = defaultRequestConfig;
        this.maxMessageSize = maxMessageSize;
        this.shutdownTimeout = shutdownTimeout;
    }

    public void start() {
        this.client.start();
    }

    @Override
    public void close() throws Exception {
        this.client.close(CloseMode.GRACEFUL);
        try {
            this.client.awaitShutdown(this.shutdownTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Expected to await HTTP client shutdown, but was interrupted; client may not be completely shut down", (Throwable)e);
        }
    }

    public RequestConfig.Builder newRequestConfig() {
        return RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
    }

    public <HttpT, RespT> void get(String path, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.GET, path, null, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void post(String path, String body, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.POST, path, body, requestConfig, Void.class, r -> null, result);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        URI target = this.buildRequestURI(path);
        SimpleRequestBuilder requestBuilder = SimpleRequestBuilder.create((Method)httpMethod).setUri(target);
        if (body != null) {
            requestBuilder.setBody(body, ContentType.APPLICATION_JSON);
        }
        SimpleHttpRequest request = requestBuilder.build();
        request.setConfig(requestConfig);
        result.transportFuture(this.client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), new JsonAsyncResponseConsumer<HttpT>(this.jsonMapper, responseType, this.maxMessageSize), new JsonCallback<HttpT, RespT>(result, transformer)));
    }

    private URI buildRequestURI(String path) {
        URI target;
        try {
            target = new URIBuilder(this.address).appendPath(path).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return target;
    }
}

