/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.util.VersionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClientFactory {
    private static final String REST_API_PATH = "/api/v1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final ZeebeClientConfiguration config;

    public HttpClientFactory(ZeebeClientConfiguration config) {
        this.config = config;
    }

    public HttpClient createClient() {
        RequestConfig defaultRequestConfig = this.defaultClientRequestConfigBuilder().build();
        CloseableHttpAsyncClient client = this.defaultClientBuilder().setDefaultRequestConfig(defaultRequestConfig).build();
        URI gatewayAddress = this.buildGatewayAddress();
        return new HttpClient(client, JSON_MAPPER, gatewayAddress, defaultRequestConfig, this.config.getMaxMessageSize(), TimeValue.ofSeconds((long)15L));
    }

    private URI buildGatewayAddress() {
        try {
            URIBuilder builder = new URIBuilder("").setHttpHost(HttpHost.create((String)this.config.getGatewayAddress())).setPort(this.config.getGatewayRestApiPort()).setPath(REST_API_PATH);
            builder.setScheme(this.config.isPlaintextConnectionEnabled() ? "http" : "https");
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpAsyncClientBuilder defaultClientBuilder() {
        BasicHeader acceptHeader = new BasicHeader("Accept", (Object)String.join((CharSequence)", ", ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_PROBLEM_JSON.getMimeType()));
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().build();
        return HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connectionManager).setDefaultHeaders(Collections.singletonList(acceptHeader)).setUserAgent("zeebe-client-java/" + VersionUtil.getVersion()).evictExpiredConnections().setCharCodingConfig(CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build()).evictIdleConnections(TimeValue.ofSeconds((long)30L)).useSystemProperties();
    }

    private RequestConfig.Builder defaultClientRequestConfigBuilder() {
        return RequestConfig.custom().setResponseTimeout(Timeout.of((Duration)this.config.getDefaultRequestTimeout())).setConnectionKeepAlive(TimeValue.of((Duration)this.config.getKeepAlive())).setHardCancellationEnabled(false);
    }
}

