/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.camunda.zeebe.client.impl.http.JsonEntity;
import io.camunda.zeebe.gateway.protocol.rest.ProblemDetail;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;

final class JsonAsyncEntityConsumer<T>
extends AbstractBinAsyncEntityConsumer<JsonEntity<T>> {
    private final ObjectMapper json;
    private final Class<T> type;
    private final int maxCapacity;
    private NonBlockingByteBufferJsonParser parser;
    private TokenBuffer buffer;
    private int bufferedBytes;
    private boolean isResponse;

    JsonAsyncEntityConsumer(ObjectMapper json, Class<T> type, int maxCapacity) {
        this.json = json;
        this.type = type;
        this.maxCapacity = maxCapacity;
    }

    protected void streamStart(ContentType contentType) throws IOException {
        if (contentType == null) {
            throw new IOException("Expected to parse a JSON response, but no content type detected");
        }
        if (ContentType.APPLICATION_JSON.isSameMimeType(contentType)) {
            this.isResponse = true;
        } else if (ContentType.APPLICATION_PROBLEM_JSON.isSameMimeType(contentType)) {
            this.isResponse = false;
        } else {
            throw new IOException("Expected to parse a application/json response or an application/problem+json error, but got: " + contentType);
        }
        if (contentType.getCharset() != null && !StandardCharsets.UTF_8.equals(contentType.getCharset())) {
            throw new IOException("Expected to parse UTF-8 JSON, but got: " + contentType.getCharset());
        }
        this.parser = (NonBlockingByteBufferJsonParser)this.json.getFactory().createNonBlockingByteBufferParser();
        this.buffer = new TokenBuffer((JsonParser)this.parser, this.json.getDeserializationContext());
    }

    protected JsonEntity<T> generateContent() throws IOException {
        if (this.parser == null || this.buffer == null) {
            return null;
        }
        this.buffer.asParserOnFirstToken();
        if (this.isResponse) {
            return JsonEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), this.type));
        }
        return JsonEntity.of((ProblemDetail)this.json.readValue(this.buffer.asParserOnFirstToken(), ProblemDetail.class));
    }

    protected int capacityIncrement() {
        return this.maxCapacity - this.bufferedBytes;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        this.bufferedBytes += src.remaining();
        this.parser.feedInput(src);
        JsonToken jsonToken = this.parser.nextToken();
        while (jsonToken != null && jsonToken != JsonToken.NOT_AVAILABLE) {
            this.buffer.copyCurrentEvent((JsonParser)this.parser);
            jsonToken = this.parser.nextToken();
        }
        if (endOfStream) {
            this.parser.endOfInput();
        }
    }

    public void releaseResources() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.buffer != null) {
            try {
                this.buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bufferedBytes = 0;
    }
}

