/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.impl.http.JsonAsyncEntityConsumer;
import io.camunda.zeebe.client.impl.http.JsonEntity;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.support.AbstractAsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

final class JsonAsyncResponseConsumer<T>
extends AbstractAsyncResponseConsumer<JsonResponse<T>, JsonEntity<T>> {
    JsonAsyncResponseConsumer(ObjectMapper jsonMapper, Class<T> type, int maxCapacity) {
        super(new JsonAsyncEntityConsumer<T>(jsonMapper, type, maxCapacity));
    }

    protected JsonResponse<T> buildResult(HttpResponse response, JsonEntity<T> entity, ContentType contentType) {
        return new JsonResponse<T>(response.getCode(), response.getReasonPhrase(), entity);
    }

    public void informationResponse(HttpResponse response, HttpContext context) {
    }

    static final class JsonResponse<T>
    extends BasicHttpResponse {
        private final JsonEntity<T> entity;

        JsonResponse(int code, String reasonPhrase, JsonEntity<T> entity) {
            super(code, reasonPhrase);
            this.entity = entity;
        }

        public JsonEntity<T> entity() {
            return this.entity;
        }
    }
}

