/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.ClientHttpException;
import io.camunda.zeebe.client.api.command.MalformedResponseException;
import io.camunda.zeebe.client.api.command.ProblemException;
import io.camunda.zeebe.client.impl.http.JsonAsyncResponseConsumer;
import io.camunda.zeebe.client.impl.http.JsonEntity;
import io.camunda.zeebe.client.impl.http.JsonResponseTransformer;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.core5.concurrent.FutureCallback;

final class JsonCallback<HttpT, RespT>
implements FutureCallback<JsonAsyncResponseConsumer.JsonResponse<HttpT>> {
    private final CompletableFuture<RespT> response;
    private final JsonResponseTransformer<HttpT, RespT> transformer;

    public JsonCallback(CompletableFuture<RespT> response, JsonResponseTransformer<HttpT, RespT> transformer) {
        this.response = response;
        this.transformer = transformer;
    }

    public void completed(JsonAsyncResponseConsumer.JsonResponse<HttpT> result) {
        JsonEntity<HttpT> body = result.entity();
        int code = result.getCode();
        String reason = result.getReasonPhrase();
        if (this.wasSuccessful(code)) {
            this.handleSuccessResponse(body, code, reason);
            return;
        }
        this.handleErrorResponse(body, code, reason);
    }

    public void failed(Exception ex) {
        if (ex instanceof ClientException) {
            this.response.completeExceptionally(ex);
            return;
        }
        this.response.completeExceptionally(new ClientException(ex));
    }

    public void cancelled() {
        this.response.cancel(true);
    }

    private void handleErrorResponse(JsonEntity<HttpT> body, int code, String reason) {
        if (body == null) {
            this.response.completeExceptionally(new ClientHttpException(code, reason));
            return;
        }
        if (!body.isProblem()) {
            this.response.completeExceptionally(new MalformedResponseException("Expected to receive a ProblemDetail as the error body, but got a successful response", code, reason));
            return;
        }
        this.response.completeExceptionally(new ProblemException(code, reason, body.problem()));
    }

    private void handleSuccessResponse(JsonEntity<HttpT> body, int code, String reason) {
        if (body == null) {
            this.response.complete(null);
            return;
        }
        if (!body.isResponse()) {
            this.response.completeExceptionally(new MalformedResponseException(String.format("Expected to receive a response body, but got an error: %s", body.problem()), code, reason));
            return;
        }
        try {
            this.response.complete(this.transformer.transform(body.response()));
        }
        catch (Exception e) {
            this.response.completeExceptionally(new MalformedResponseException(code, reason, e));
        }
    }

    private boolean wasSuccessful(int code) {
        return code >= 200 && code < 400;
    }
}

