/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import io.camunda.zeebe.gateway.protocol.rest.ProblemDetail;
import java.util.NoSuchElementException;
import java.util.Objects;

interface JsonEntity<T> {
    public T response();

    public ProblemDetail problem();

    public boolean isResponse();

    public boolean isProblem();

    public static <T> JsonEntity<T> of(T response) {
        return new Response(response);
    }

    public static <T> JsonEntity<T> of(ProblemDetail error) {
        return new Error(error);
    }

    public static final class Response<T>
    implements JsonEntity<T> {
        private final T response;

        private Response(T response) {
            this.response = Objects.requireNonNull(response, "must specify a response");
        }

        @Override
        public T response() {
            return this.response;
        }

        @Override
        public ProblemDetail problem() {
            throw new NoSuchElementException("Expected to get a problem, but this is a successful response; use #response()");
        }

        @Override
        public boolean isResponse() {
            return true;
        }

        @Override
        public boolean isProblem() {
            return false;
        }
    }

    public static final class Error<T>
    implements JsonEntity<T> {
        private final ProblemDetail problem;

        private Error(ProblemDetail problem) {
            this.problem = Objects.requireNonNull(problem, "must specify a problem");
        }

        @Override
        public T response() {
            throw new NoSuchElementException("Expected to get a response, but this is a problem; use #problem()");
        }

        @Override
        public ProblemDetail problem() {
            return this.problem;
        }

        @Override
        public boolean isResponse() {
            return false;
        }

        @Override
        public boolean isProblem() {
            return true;
        }
    }
}

