/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.gateway.protocol.rest.Partition;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"nodeId", "host", "port", "partitions", "version"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BrokerInfo {
    public static final String JSON_PROPERTY_NODE_ID = "nodeId";
    private Integer nodeId;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;
    public static final String JSON_PROPERTY_PARTITIONS = "partitions";
    private List<Partition> partitions;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public BrokerInfo nodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="nodeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNodeId() {
        return this.nodeId;
    }

    @JsonProperty(value="nodeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public BrokerInfo host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public BrokerInfo port(Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public BrokerInfo partitions(List<Partition> partitions) {
        this.partitions = partitions;
        return this;
    }

    public BrokerInfo addPartitionsItem(Partition partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
    }

    public BrokerInfo version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerInfo brokerInfo = (BrokerInfo)o;
        return Objects.equals(this.nodeId, brokerInfo.nodeId) && Objects.equals(this.host, brokerInfo.host) && Objects.equals(this.port, brokerInfo.port) && Objects.equals(this.partitions, brokerInfo.partitions) && Objects.equals(this.version, brokerInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.host, this.port, this.partitions, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrokerInfo {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNodeId() != null) {
            try {
                joiner.add(String.format("%snodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNodeId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHost() != null) {
            try {
                joiner.add(String.format("%shost%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHost()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPort() != null) {
            try {
                joiner.add(String.format("%sport%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPort()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPartitions() != null) {
            for (int i = 0; i < this.getPartitions().size(); ++i) {
                if (this.getPartitions().get(i) == null) continue;
                joiner.add(this.getPartitions().get(i).toUrlQueryString(String.format("%spartitions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

