/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.gateway.protocol.rest.BrokerInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"brokers", "clusterSize", "partitionsCount", "replicationFactor", "gatewayVersion"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyResponse {
    public static final String JSON_PROPERTY_BROKERS = "brokers";
    private List<BrokerInfo> brokers;
    public static final String JSON_PROPERTY_CLUSTER_SIZE = "clusterSize";
    private Integer clusterSize;
    public static final String JSON_PROPERTY_PARTITIONS_COUNT = "partitionsCount";
    private Integer partitionsCount;
    public static final String JSON_PROPERTY_REPLICATION_FACTOR = "replicationFactor";
    private Integer replicationFactor;
    public static final String JSON_PROPERTY_GATEWAY_VERSION = "gatewayVersion";
    private String gatewayVersion;

    public TopologyResponse brokers(List<BrokerInfo> brokers) {
        this.brokers = brokers;
        return this;
    }

    public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<BrokerInfo>();
        }
        this.brokers.add(brokersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="brokers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BrokerInfo> getBrokers() {
        return this.brokers;
    }

    @JsonProperty(value="brokers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrokers(List<BrokerInfo> brokers) {
        this.brokers = brokers;
    }

    public TopologyResponse clusterSize(Integer clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="clusterSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getClusterSize() {
        return this.clusterSize;
    }

    @JsonProperty(value="clusterSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClusterSize(Integer clusterSize) {
        this.clusterSize = clusterSize;
    }

    public TopologyResponse partitionsCount(Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="partitionsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPartitionsCount() {
        return this.partitionsCount;
    }

    @JsonProperty(value="partitionsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitionsCount(Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public TopologyResponse replicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    @Nullable
    @JsonProperty(value="replicationFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    @JsonProperty(value="replicationFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public TopologyResponse gatewayVersion(String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="gatewayVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGatewayVersion() {
        return this.gatewayVersion;
    }

    @JsonProperty(value="gatewayVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGatewayVersion(String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyResponse topologyResponse = (TopologyResponse)o;
        return Objects.equals(this.brokers, topologyResponse.brokers) && Objects.equals(this.clusterSize, topologyResponse.clusterSize) && Objects.equals(this.partitionsCount, topologyResponse.partitionsCount) && Objects.equals(this.replicationFactor, topologyResponse.replicationFactor) && Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion);
    }

    public int hashCode() {
        return Objects.hash(this.brokers, this.clusterSize, this.partitionsCount, this.replicationFactor, this.gatewayVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyResponse {\n");
        sb.append("    brokers: ").append(this.toIndentedString(this.brokers)).append("\n");
        sb.append("    clusterSize: ").append(this.toIndentedString(this.clusterSize)).append("\n");
        sb.append("    partitionsCount: ").append(this.toIndentedString(this.partitionsCount)).append("\n");
        sb.append("    replicationFactor: ").append(this.toIndentedString(this.replicationFactor)).append("\n");
        sb.append("    gatewayVersion: ").append(this.toIndentedString(this.gatewayVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBrokers() != null) {
            for (int i = 0; i < this.getBrokers().size(); ++i) {
                if (this.getBrokers().get(i) == null) continue;
                joiner.add(this.getBrokers().get(i).toUrlQueryString(String.format("%sbrokers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getClusterSize() != null) {
            try {
                joiner.add(String.format("%sclusterSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getClusterSize()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPartitionsCount() != null) {
            try {
                joiner.add(String.format("%spartitionsCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPartitionsCount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getReplicationFactor() != null) {
            try {
                joiner.add(String.format("%sreplicationFactor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReplicationFactor()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getGatewayVersion() != null) {
            try {
                joiner.add(String.format("%sgatewayVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getGatewayVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

