/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"assignee", "allowOverride", "action"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserTaskAssignmentRequest {
    public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
    private String assignee;
    public static final String JSON_PROPERTY_ALLOW_OVERRIDE = "allowOverride";
    private Boolean allowOverride;
    public static final String JSON_PROPERTY_ACTION = "action";
    private String action;

    public UserTaskAssignmentRequest assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignee() {
        return this.assignee;
    }

    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public UserTaskAssignmentRequest allowOverride(Boolean allowOverride) {
        this.allowOverride = allowOverride;
        return this;
    }

    @Nullable
    @JsonProperty(value="allowOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowOverride() {
        return this.allowOverride;
    }

    @JsonProperty(value="allowOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowOverride(Boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public UserTaskAssignmentRequest action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(String action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskAssignmentRequest userTaskAssignmentRequest = (UserTaskAssignmentRequest)o;
        return Objects.equals(this.assignee, userTaskAssignmentRequest.assignee) && Objects.equals(this.allowOverride, userTaskAssignmentRequest.allowOverride) && Objects.equals(this.action, userTaskAssignmentRequest.action);
    }

    public int hashCode() {
        return Objects.hash(this.assignee, this.allowOverride, this.action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskAssignmentRequest {\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    allowOverride: ").append(this.toIndentedString(this.allowOverride)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAssignee() != null) {
            try {
                joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAllowOverride() != null) {
            try {
                joiner.add(String.format("%sallowOverride%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAllowOverride()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAction() != null) {
            try {
                joiner.add(String.format("%saction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAction()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

