/*
 * Zeebe REST API
 * API for communicating with the Zeebe cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * UserTaskAssignmentRequest
 */
@JsonPropertyOrder({
  UserTaskAssignmentRequest.JSON_PROPERTY_ASSIGNEE,
  UserTaskAssignmentRequest.JSON_PROPERTY_ALLOW_OVERRIDE,
  UserTaskAssignmentRequest.JSON_PROPERTY_ACTION
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-03T14:59:23.221713690Z[GMT]", comments = "Generator version: 7.4.0")
public class UserTaskAssignmentRequest {
  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private String assignee;

  public static final String JSON_PROPERTY_ALLOW_OVERRIDE = "allowOverride";
  private Boolean allowOverride;

  public static final String JSON_PROPERTY_ACTION = "action";
  private String action;

  public UserTaskAssignmentRequest() {
  }

  public UserTaskAssignmentRequest assignee(String assignee) {
    
    this.assignee = assignee;
    return this;
  }

   /**
   * The assignee for the user task. The assignee must not be empty or &#x60;null&#x60;.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAssignee() {
    return assignee;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }


  public UserTaskAssignmentRequest allowOverride(Boolean allowOverride) {
    
    this.allowOverride = allowOverride;
    return this;
  }

   /**
   * By default, the task is reassigned if it was already assigned. Set this to &#x60;false&#x60; to return an error in such cases. The task must then first be unassigned to be assigned again. Use this when you have users picking from group task queues to prevent race conditions. 
   * @return allowOverride
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowOverride() {
    return allowOverride;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowOverride(Boolean allowOverride) {
    this.allowOverride = allowOverride;
  }


  public UserTaskAssignmentRequest action(String action) {
    
    this.action = action;
    return this;
  }

   /**
   * A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \&quot;assign\&quot;. 
   * @return action
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAction() {
    return action;
  }


  @JsonProperty(JSON_PROPERTY_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAction(String action) {
    this.action = action;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskAssignmentRequest userTaskAssignmentRequest = (UserTaskAssignmentRequest) o;
    return Objects.equals(this.assignee, userTaskAssignmentRequest.assignee) &&
        Objects.equals(this.allowOverride, userTaskAssignmentRequest.allowOverride) &&
        Objects.equals(this.action, userTaskAssignmentRequest.action);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, allowOverride, action);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskAssignmentRequest {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    allowOverride: ").append(toIndentedString(allowOverride)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `allowOverride` to the URL query string
    if (getAllowOverride() != null) {
      try {
        joiner.add(String.format("%sallowOverride%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAllowOverride()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `action` to the URL query string
    if (getAction() != null) {
      try {
        joiner.add(String.format("%saction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAction()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

