/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.DeleteResourceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DeleteResourceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.response.DeleteResourceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class DeleteResourceCommandImpl
implements DeleteResourceCommandStep1 {
    private final GatewayOuterClass.DeleteResourceRequest.Builder requestBuilder = GatewayOuterClass.DeleteResourceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;

    public DeleteResourceCommandImpl(long resourceKey, GatewayGrpc.GatewayStub asyncStub, Predicate<CredentialsProvider.StatusCode> retryPredicate, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.requestBuilder.setResourceKey(resourceKey);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public FinalCommandStep<DeleteResourceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<DeleteResourceResponse> send() {
        GatewayOuterClass.DeleteResourceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<DeleteResourceResponse, GatewayOuterClass.DeleteResourceResponse> future = new RetriableClientFutureImpl<DeleteResourceResponse, GatewayOuterClass.DeleteResourceResponse>(DeleteResourceResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.DeleteResourceResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.DeleteResourceResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.DeleteResourceRequest request, StreamObserver<GatewayOuterClass.DeleteResourceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deleteResource(request, streamObserver);
    }
}

