/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.protocol.rest.ProblemDetail;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApiEntityConsumer<T>
extends AbstractBinAsyncEntityConsumer<ApiEntity<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiEntityConsumer.class);
    private final ObjectMapper json;
    private final Class<T> type;
    private final int maxCapacity;
    private NonBlockingByteBufferJsonParser parser;
    private TokenBuffer buffer;
    private int bufferedBytes;
    private boolean isResponse;
    private boolean isUnknownContentType;
    private byte[] nonJsonBody;

    ApiEntityConsumer(ObjectMapper json, Class<T> type, int maxCapacity) {
        this.json = json;
        this.type = type;
        this.maxCapacity = maxCapacity;
    }

    protected void streamStart(ContentType contentType) throws IOException {
        if (ContentType.APPLICATION_JSON.isSameMimeType(contentType)) {
            this.isResponse = true;
        } else if (ContentType.APPLICATION_PROBLEM_JSON.isSameMimeType(contentType)) {
            this.isResponse = false;
        } else {
            this.isUnknownContentType = true;
            this.nonJsonBody = new byte[1024];
            return;
        }
        this.parser = (NonBlockingByteBufferJsonParser)this.json.getFactory().createNonBlockingByteBufferParser();
        this.buffer = new TokenBuffer((JsonParser)this.parser, this.json.getDeserializationContext());
    }

    protected ApiEntity<T> generateContent() throws IOException {
        if (this.parser == null || this.buffer == null) {
            if (this.nonJsonBody == null || this.bufferedBytes == 0) {
                return null;
            }
            return ApiEntity.of(ByteBuffer.wrap(this.nonJsonBody, 0, this.bufferedBytes));
        }
        this.buffer.asParserOnFirstToken();
        try {
            if (this.isResponse) {
                return ApiEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), this.type));
            }
            return ApiEntity.of((ProblemDetail)this.json.readValue(this.buffer.asParserOnFirstToken(), ProblemDetail.class));
        }
        catch (Exception e) {
            String jsonString = this.getJsonString();
            return ApiEntity.of(new ProblemDetail().title("Unexpected server response").status(500).detail(jsonString));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getJsonString() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            String string;
            block13: {
                JsonGenerator generator = this.json.createGenerator((OutputStream)output);
                try {
                    this.buffer.serialize(generator);
                    generator.flush();
                    string = output.toString(StandardCharsets.UTF_8.name());
                    if (generator == null) break block13;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to serialize JSON string", (Throwable)ex);
            return "Original response cannot be constructed";
        }
    }

    protected int capacityIncrement() {
        return this.maxCapacity - this.bufferedBytes;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        int offset = this.bufferedBytes;
        this.bufferedBytes += src.remaining();
        if (this.isUnknownContentType) {
            this.consumeNonJsonBody(src, offset);
        } else {
            this.consumeJsonBody(src, endOfStream);
        }
    }

    public void releaseResources() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close JSON parser", (Throwable)e);
            }
        }
        if (this.buffer != null) {
            try {
                this.buffer.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close JSON parser", (Throwable)e);
            }
        }
        this.bufferedBytes = 0;
    }

    private void consumeNonJsonBody(ByteBuffer src, int offset) {
        if (this.nonJsonBody.length < this.bufferedBytes) {
            this.nonJsonBody = Arrays.copyOf(this.nonJsonBody, this.nonJsonBody.length + 1024);
        }
        src.get(this.nonJsonBody, offset, src.remaining());
    }

    private void consumeJsonBody(ByteBuffer src, boolean endOfStream) throws IOException {
        this.parser.feedInput(src);
        JsonToken jsonToken = this.parser.nextToken();
        while (jsonToken != null && jsonToken != JsonToken.NOT_AVAILABLE) {
            this.buffer.copyCurrentEvent((JsonParser)this.parser);
            jsonToken = this.parser.nextToken();
        }
        if (endOfStream) {
            this.parser.endOfInput();
        }
    }
}

