/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client;

import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientCloudBuilderStep1;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.ExperimentalApi;
import io.camunda.zeebe.client.api.command.AssignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.BroadcastSignalCommandStep1;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeleteResourceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.zeebe.client.api.command.MigrateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.command.UnassignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateTimeoutJobCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.search.ProcessInstanceQuery;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.ZeebeClientCloudBuilderImpl;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;

public interface ZeebeClient
extends AutoCloseable,
JobClient {
    public static ZeebeClient newClient() {
        return ZeebeClient.newClientBuilder().build();
    }

    public static ZeebeClient newClient(ZeebeClientConfiguration configuration) {
        return new ZeebeClientImpl(configuration);
    }

    public static ZeebeClientBuilder newClientBuilder() {
        return new ZeebeClientBuilderImpl();
    }

    public static ZeebeClientCloudBuilderStep1 newCloudClientBuilder() {
        return new ZeebeClientCloudBuilderImpl();
    }

    public TopologyRequestStep1 newTopologyRequest();

    public ZeebeClientConfiguration getConfiguration();

    @Override
    public void close();

    public DeployProcessCommandStep1 newDeployCommand();

    public DeployResourceCommandStep1 newDeployResourceCommand();

    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand();

    public ModifyProcessInstanceCommandStep1 newModifyProcessInstanceCommand(long var1);

    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/14907")
    public MigrateProcessInstanceCommandStep1 newMigrateProcessInstanceCommand(long var1);

    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long var1);

    public SetVariablesCommandStep1 newSetVariablesCommand(long var1);

    public EvaluateDecisionCommandStep1 newEvaluateDecisionCommand();

    public PublishMessageCommandStep1 newPublishMessageCommand();

    public BroadcastSignalCommandStep1 newBroadcastSignalCommand();

    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long var1);

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long var1);

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob var1);

    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(long var1);

    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(ActivatedJob var1);

    public JobWorkerBuilderStep1 newWorker();

    public DeleteResourceCommandStep1 newDeleteResourceCommand(long var1);

    public CompleteUserTaskCommandStep1 newUserTaskCompleteCommand(long var1);

    public AssignUserTaskCommandStep1 newUserTaskAssignCommand(long var1);

    public UpdateUserTaskCommandStep1 newUserTaskUpdateCommand(long var1);

    public UnassignUserTaskCommandStep1 newUserTaskUnassignCommand(long var1);

    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/20596")
    public ProcessInstanceQuery newProcessInstanceQuery();
}

