/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.response.UpdateRetriesJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.response.UpdateRetriesJobResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class JobUpdateRetriesCommandImpl
implements UpdateRetriesJobCommandStep1,
UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobRetriesRequest.Builder builder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;

    public JobUpdateRetriesCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.UpdateJobRetriesRequest.newBuilder();
        this.builder.setJobKey(jobKey);
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateRetriesJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<UpdateRetriesJobResponse> send() {
        GatewayOuterClass.UpdateJobRetriesRequest request = this.builder.build();
        RetriableClientFutureImpl<UpdateRetriesJobResponse, GatewayOuterClass.UpdateJobRetriesResponse> future = new RetriableClientFutureImpl<UpdateRetriesJobResponse, GatewayOuterClass.UpdateJobRetriesResponse>(UpdateRetriesJobResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobRetries(request, streamObserver);
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 operationReference(long operationReference) {
        this.builder.setOperationReference(operationReference);
        return this;
    }
}

