/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.UpdateTimeoutJobCommandStep1;
import io.camunda.zeebe.client.api.response.UpdateTimeoutJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.response.UpdateTimeoutJobResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class JobUpdateTimeoutCommandImpl
implements UpdateTimeoutJobCommandStep1,
UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobTimeoutRequest.Builder builder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;

    public JobUpdateTimeoutCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.UpdateJobTimeoutRequest.newBuilder();
        this.builder.setJobKey(jobKey);
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 timeout(long timeout) {
        this.builder.setTimeout(timeout);
        return this;
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 timeout(Duration timeout) {
        return this.timeout(timeout.toMillis());
    }

    @Override
    public FinalCommandStep<UpdateTimeoutJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<UpdateTimeoutJobResponse> send() {
        GatewayOuterClass.UpdateJobTimeoutRequest request = this.builder.build();
        RetriableClientFutureImpl<UpdateTimeoutJobResponse, GatewayOuterClass.UpdateJobTimeoutResponse> future = new RetriableClientFutureImpl<UpdateTimeoutJobResponse, GatewayOuterClass.UpdateJobTimeoutResponse>(UpdateTimeoutJobResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.UpdateJobTimeoutRequest request, StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobTimeout(request, streamObserver);
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 operationReference(long operationReference) {
        this.builder.setOperationReference(operationReference);
        return this;
    }
}

