/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"ownerKey", "ownerType", "resourceKey", "resourceType", "permissions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationAssignRequest {
    public static final String JSON_PROPERTY_OWNER_KEY = "ownerKey";
    private String ownerKey;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_RESOURCE_KEY = "resourceKey";
    private String resourceKey;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private String resourceType;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<String> permissions = new ArrayList<String>();

    public AuthorizationAssignRequest ownerKey(String ownerKey) {
        this.ownerKey = ownerKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerKey() {
        return this.ownerKey;
    }

    @JsonProperty(value="ownerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerKey(String ownerKey) {
        this.ownerKey = ownerKey;
    }

    public AuthorizationAssignRequest ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public AuthorizationAssignRequest resourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceKey() {
        return this.resourceKey;
    }

    @JsonProperty(value="resourceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public AuthorizationAssignRequest resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationAssignRequest permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationAssignRequest addPermissionsItem(String permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationAssignRequest authorizationAssignRequest = (AuthorizationAssignRequest)o;
        return Objects.equals(this.ownerKey, authorizationAssignRequest.ownerKey) && Objects.equals((Object)this.ownerType, (Object)authorizationAssignRequest.ownerType) && Objects.equals(this.resourceKey, authorizationAssignRequest.resourceKey) && Objects.equals(this.resourceType, authorizationAssignRequest.resourceType) && Objects.equals(this.permissions, authorizationAssignRequest.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ownerKey, this.ownerType, this.resourceKey, this.resourceType, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationAssignRequest {\n");
        sb.append("    ownerKey: ").append(this.toIndentedString(this.ownerKey)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    resourceKey: ").append(this.toIndentedString(this.resourceKey)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOwnerKey() != null) {
            try {
                joiner.add(String.format("%sownerKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOwnerKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOwnerType() != null) {
            try {
                joiner.add(String.format("%sownerType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOwnerType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceKey() != null) {
            try {
                joiner.add(String.format("%sresourceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getResourceKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceType() != null) {
            try {
                joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                try {
                    joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum OwnerTypeEnum {
        USER("USER"),
        ROLE("ROLE"),
        GROUP("GROUP"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

