/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.VariableValueFilterRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"key", "variables"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceFilterRequest {
    public static final String JSON_PROPERTY_KEY = "key";
    private List<Long> key = new ArrayList<Long>();
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<VariableValueFilterRequest> variables = new ArrayList<VariableValueFilterRequest>();

    public ProcessInstanceFilterRequest key(List<Long> key) {
        this.key = key;
        return this;
    }

    public ProcessInstanceFilterRequest addKeyItem(Long keyItem) {
        if (this.key == null) {
            this.key = new ArrayList<Long>();
        }
        this.key.add(keyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKey(List<Long> key) {
        this.key = key;
    }

    public ProcessInstanceFilterRequest variables(List<VariableValueFilterRequest> variables) {
        this.variables = variables;
        return this;
    }

    public ProcessInstanceFilterRequest addVariablesItem(VariableValueFilterRequest variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<VariableValueFilterRequest>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VariableValueFilterRequest> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(List<VariableValueFilterRequest> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceFilterRequest processInstanceFilterRequest = (ProcessInstanceFilterRequest)o;
        return Objects.equals(this.key, processInstanceFilterRequest.key) && Objects.equals(this.variables, processInstanceFilterRequest.variables);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceFilterRequest {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getKey() != null) {
            for (i = 0; i < this.getKey().size(); ++i) {
                try {
                    joiner.add(String.format("%skey%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getKey().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getVariables() != null) {
            for (i = 0; i < this.getVariables().size(); ++i) {
                if (this.getVariables().get(i) == null) continue;
                joiner.add(this.getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

