/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.BuilderUtils;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.DataSizeUtil;
import io.camunda.zeebe.client.impl.util.Environment;
import io.grpc.ClientInterceptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;

public final class ZeebeClientBuilderImpl
implements ZeebeClientBuilder,
ZeebeClientConfiguration {
    public static final String PLAINTEXT_CONNECTION_VAR = "ZEEBE_INSECURE_CONNECTION";
    public static final String CA_CERTIFICATE_VAR = "ZEEBE_CA_CERTIFICATE_PATH";
    public static final String KEEP_ALIVE_VAR = "ZEEBE_KEEP_ALIVE";
    public static final String OVERRIDE_AUTHORITY_VAR = "ZEEBE_OVERRIDE_AUTHORITY";
    public static final String CAMUNDA_CLIENT_WORKER_STREAM_ENABLED = "ZEEBE_CLIENT_WORKER_STREAM_ENABLED";
    public static final String DEFAULT_GATEWAY_ADDRESS = "0.0.0.0:26500";
    public static final URI DEFAULT_GRPC_ADDRESS = ZeebeClientBuilderImpl.getURIFromString("http://0.0.0.0:26500");
    public static final URI DEFAULT_REST_ADDRESS = ZeebeClientBuilderImpl.getURIFromString("http://0.0.0.0:8080");
    public static final String REST_ADDRESS_VAR = "ZEEBE_REST_ADDRESS";
    public static final String GRPC_ADDRESS_VAR = "ZEEBE_GRPC_ADDRESS";
    public static final String PREFER_REST_VAR = "ZEEBE_PREFER_REST";
    public static final String DEFAULT_TENANT_ID_VAR = "ZEEBE_DEFAULT_TENANT_ID";
    public static final String DEFAULT_JOB_WORKER_TENANT_IDS_VAR = "ZEEBE_DEFAULT_JOB_WORKER_TENANT_IDS";
    public static final String DEFAULT_JOB_WORKER_NAME_VAR = "default";
    public static final String USE_DEFAULT_RETRY_POLICY_VAR = "ZEEBE_CLIENT_USE_DEFAULT_RETRY_POLICY";
    public static final Duration DEFAULT_MESSAGE_TTL = Duration.ofHours(1L);
    private static final String TENANT_ID_LIST_SEPARATOR = ",";
    private static final boolean DEFAULT_PREFER_REST_OVER_GRPC = false;
    private boolean applyEnvironmentVariableOverrides = true;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final List<AsyncExecChainHandler> chainHandlers = new ArrayList<AsyncExecChainHandler>();
    private String gatewayAddress = "0.0.0.0:26500";
    private URI restAddress = DEFAULT_REST_ADDRESS;
    private URI grpcAddress = DEFAULT_GRPC_ADDRESS;
    private boolean preferRestOverGrpc = false;
    private String defaultTenantId = "<default>";
    private List<String> defaultJobWorkerTenantIds = Collections.singletonList("<default>");
    private int jobWorkerMaxJobsActive = 32;
    private int numJobWorkerExecutionThreads = 1;
    private String defaultJobWorkerName = "default";
    private Duration defaultJobTimeout = Duration.ofMinutes(5L);
    private Duration defaultJobPollInterval = Duration.ofMillis(100L);
    private Duration defaultMessageTimeToLive = DEFAULT_MESSAGE_TTL;
    private Duration defaultRequestTimeout = Duration.ofSeconds(10L);
    private boolean usePlaintextConnection = false;
    private String certificatePath;
    private CredentialsProvider credentialsProvider;
    private Duration keepAlive = Duration.ofSeconds(45L);
    private JsonMapper jsonMapper = new ZeebeObjectMapper();
    private String overrideAuthority;
    private int maxMessageSize = 0x500000;
    private int maxMetadataSize = 16384;
    private boolean streamEnabled = false;
    private boolean grpcAddressUsed = true;
    private ScheduledExecutorService jobWorkerExecutor;
    private boolean ownsJobWorkerExecutor;
    private boolean useDefaultRetryPolicy;

    @Override
    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    @Override
    public URI getRestAddress() {
        return this.restAddress;
    }

    @Override
    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    @Override
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    @Override
    public List<String> getDefaultJobWorkerTenantIds() {
        return this.defaultJobWorkerTenantIds;
    }

    @Override
    public int getNumJobWorkerExecutionThreads() {
        return this.numJobWorkerExecutionThreads;
    }

    @Override
    public int getDefaultJobWorkerMaxJobsActive() {
        return this.jobWorkerMaxJobsActive;
    }

    @Override
    public String getDefaultJobWorkerName() {
        return this.defaultJobWorkerName;
    }

    @Override
    public Duration getDefaultJobTimeout() {
        return this.defaultJobTimeout;
    }

    @Override
    public Duration getDefaultJobPollInterval() {
        return this.defaultJobPollInterval;
    }

    @Override
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    @Override
    public Duration getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    @Override
    public boolean isPlaintextConnectionEnabled() {
        return this.usePlaintextConnection;
    }

    @Override
    public String getCaCertificatePath() {
        return this.certificatePath;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public int getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    @Override
    public ScheduledExecutorService jobWorkerExecutor() {
        return this.jobWorkerExecutor;
    }

    @Override
    public boolean ownsJobWorkerExecutor() {
        return this.ownsJobWorkerExecutor;
    }

    @Override
    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.streamEnabled;
    }

    @Override
    public boolean useDefaultRetryPolicy() {
        return this.useDefaultRetryPolicy;
    }

    @Override
    public boolean preferRestOverGrpc() {
        return this.preferRestOverGrpc;
    }

    @Override
    public ZeebeClientBuilder withProperties(Properties properties) {
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.applyEnvironmentVariableOverrides", value -> this.applyEnvironmentVariableOverrides(Boolean.parseBoolean(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.gateway.grpc.address", value -> this.grpcAddress(ZeebeClientBuilderImpl.getURIFromString(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.gateway.rest.address", value -> this.restAddress(ZeebeClientBuilderImpl.getURIFromString(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.gateway.address", this::gatewayAddress);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.gateway.preferRestOverGrpc", value -> this.preferRestOverGrpc(Boolean.parseBoolean(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.tenantId", this::defaultTenantId);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.tenantIds", value -> {
            List<String> tenantIds = Arrays.asList(value.split(TENANT_ID_LIST_SEPARATOR));
            this.defaultJobWorkerTenantIds(tenantIds);
        });
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.threads", value -> this.numJobWorkerExecutionThreads(Integer.parseInt(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.maxJobsActive", value -> this.defaultJobWorkerMaxJobsActive(Integer.parseInt(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.name", this::defaultJobWorkerName);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.job.timeout", value -> this.defaultJobTimeout(Duration.ofMillis(Long.parseLong(value))));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.job.pollinterval", value -> this.defaultJobPollInterval(Duration.ofMillis(Long.parseLong(value))));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.message.timeToLive", value -> this.defaultMessageTimeToLive(Duration.ofMillis(Long.parseLong(value))));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.requestTimeout", value -> this.defaultRequestTimeout(Duration.ofMillis(Long.parseLong(value))));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.security.plaintext", value -> {
            if (!"false".equalsIgnoreCase((String)value)) {
                this.usePlaintext();
            }
        });
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.security.certpath", this::caCertificatePath);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.keepalive", this::keepAlive);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.overrideauthority", this::overrideAuthority);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.maxMessageSize", value -> this.maxMessageSize(DataSizeUtil.parse(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.maxMetadataSize", value -> this.maxMetadataSize(DataSizeUtil.parse(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.stream.enabled", value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)));
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.useDefaultRetryPolicy", value -> this.useDefaultRetryPolicy(Boolean.parseBoolean(value)));
        return this;
    }

    @Override
    public ZeebeClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.applyEnvironmentVariableOverrides = applyEnvironmentVariableOverrides;
        return this;
    }

    @Override
    public ZeebeClientBuilder gatewayAddress(String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
        this.grpcAddressUsed = false;
        return this;
    }

    @Override
    public ZeebeClientBuilder restAddress(URI restAddress) {
        if (restAddress != null && restAddress.getHost() == null) {
            throw new IllegalArgumentException("restAddress must be an absolute URI");
        }
        this.restAddress = restAddress;
        return this;
    }

    @Override
    public ZeebeClientBuilder grpcAddress(URI grpcAddress) {
        if (grpcAddress != null && grpcAddress.getHost() == null) {
            throw new IllegalArgumentException("grpcAddress must be an absolute URI");
        }
        this.grpcAddress = grpcAddress;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultTenantId(String tenantId) {
        this.defaultTenantId = tenantId;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        this.defaultJobWorkerTenantIds = tenantIds;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.jobWorkerMaxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public ZeebeClientBuilder numJobWorkerExecutionThreads(int numSubscriptionThreads) {
        this.numJobWorkerExecutionThreads = numSubscriptionThreads;
        return this;
    }

    @Override
    public ZeebeClientBuilder jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.jobWorkerExecutor = executor;
        this.ownsJobWorkerExecutor = takeOwnership;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerName(String workerName) {
        if (workerName != null) {
            this.defaultJobWorkerName = workerName;
        }
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobTimeout(Duration timeout) {
        this.defaultJobTimeout = timeout;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.defaultJobPollInterval = pollInterval;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.defaultMessageTimeToLive = timeToLive;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.defaultRequestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeClientBuilder usePlaintext() {
        this.usePlaintextConnection = true;
        return this;
    }

    @Override
    public ZeebeClientBuilder caCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    @Override
    public ZeebeClientBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    @Override
    public ZeebeClientBuilder keepAlive(Duration keepAlive) {
        if (keepAlive.isNegative() || keepAlive.isZero()) {
            throw new IllegalArgumentException("The keep alive must be a positive number.");
        }
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public ZeebeClientBuilder withInterceptors(ClientInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    @Override
    public ZeebeClientBuilder withChainHandlers(AsyncExecChainHandler ... chainHandler) {
        this.chainHandlers.addAll(Arrays.asList(chainHandler));
        return this;
    }

    @Override
    public ZeebeClientBuilder withJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    @Override
    public ZeebeClientBuilder overrideAuthority(String authority) {
        this.overrideAuthority = authority;
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMetadataSize(int maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.streamEnabled = streamEnabled;
        return this;
    }

    @Override
    public ZeebeClientBuilder useDefaultRetryPolicy(boolean useDefaultRetryPolicy) {
        this.useDefaultRetryPolicy = useDefaultRetryPolicy;
        return this;
    }

    @Override
    public ZeebeClientBuilder preferRestOverGrpc(boolean preferRestOverGrpc) {
        this.preferRestOverGrpc = preferRestOverGrpc;
        return this;
    }

    @Override
    public ZeebeClient build() {
        if (this.applyEnvironmentVariableOverrides) {
            this.applyOverrides();
        }
        if (!this.grpcAddressUsed) {
            String scheme = this.usePlaintextConnection ? "http://" : "https://";
            this.grpcAddress(ZeebeClientBuilderImpl.getURIFromString(scheme + this.getGatewayAddress()));
        }
        return new ZeebeClientImpl(this);
    }

    private void keepAlive(String keepAlive) {
        this.keepAlive(Duration.ofMillis(Long.parseUnsignedLong(keepAlive)));
    }

    private void applyOverrides() {
        BuilderUtils.applyIfNotNull(PLAINTEXT_CONNECTION_VAR, value -> {
            this.usePlaintextConnection = Boolean.parseBoolean(value);
        });
        BuilderUtils.applyIfNotNull(CA_CERTIFICATE_VAR, this::caCertificatePath);
        BuilderUtils.applyIfNotNull(KEEP_ALIVE_VAR, this::keepAlive);
        BuilderUtils.applyIfNotNull(OVERRIDE_AUTHORITY_VAR, this::overrideAuthority);
        if (this.shouldUseDefaultCredentialsProvider()) {
            this.credentialsProvider = this.createDefaultCredentialsProvider();
        }
        BuilderUtils.applyIfNotNull(GRPC_ADDRESS_VAR, value -> this.grpcAddress(ZeebeClientBuilderImpl.getURIFromString(value)));
        BuilderUtils.applyIfNotNull(REST_ADDRESS_VAR, value -> this.restAddress(ZeebeClientBuilderImpl.getURIFromString(value)));
        BuilderUtils.applyIfNotNull(PREFER_REST_VAR, value -> this.preferRestOverGrpc(Boolean.parseBoolean(value)));
        if (Environment.system().isDefined(DEFAULT_TENANT_ID_VAR)) {
            this.defaultTenantId(Environment.system().get(DEFAULT_TENANT_ID_VAR));
        }
        BuilderUtils.applyIfNotNull(DEFAULT_TENANT_ID_VAR, this::defaultTenantId);
        BuilderUtils.applyIfNotNull(DEFAULT_JOB_WORKER_TENANT_IDS_VAR, value -> {
            List<String> tenantIds = Arrays.asList(value.split(TENANT_ID_LIST_SEPARATOR));
            this.defaultJobWorkerTenantIds(tenantIds);
        });
        BuilderUtils.applyIfNotNull(CAMUNDA_CLIENT_WORKER_STREAM_ENABLED, value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)));
        BuilderUtils.applyIfNotNull(USE_DEFAULT_RETRY_POLICY_VAR, value -> this.useDefaultRetryPolicy(Boolean.parseBoolean(value)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        BuilderUtils.appendProperty(sb, "gatewayAddress", this.gatewayAddress);
        BuilderUtils.appendProperty(sb, "grpcAddress", this.grpcAddress);
        BuilderUtils.appendProperty(sb, "restAddress", this.restAddress);
        BuilderUtils.appendProperty(sb, "defaultTenantId", this.defaultTenantId);
        BuilderUtils.appendProperty(sb, "jobWorkerMaxJobsActive", this.jobWorkerMaxJobsActive);
        BuilderUtils.appendProperty(sb, "numJobWorkerExecutionThreads", this.numJobWorkerExecutionThreads);
        BuilderUtils.appendProperty(sb, "defaultJobWorkerName", this.defaultJobWorkerName);
        BuilderUtils.appendProperty(sb, "defaultJobTimeout", this.defaultJobTimeout);
        BuilderUtils.appendProperty(sb, "defaultJobPollInterval", this.defaultJobPollInterval);
        BuilderUtils.appendProperty(sb, "defaultMessageTimeToLive", this.defaultMessageTimeToLive);
        BuilderUtils.appendProperty(sb, "defaultRequestTimeout", this.defaultRequestTimeout);
        BuilderUtils.appendProperty(sb, "overrideAuthority", this.overrideAuthority);
        BuilderUtils.appendProperty(sb, "maxMessageSize", this.maxMessageSize);
        BuilderUtils.appendProperty(sb, "maxMetadataSize", this.maxMetadataSize);
        BuilderUtils.appendProperty(sb, "jobWorkerExecutor", this.jobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "ownsJobWorkerExecutor", this.ownsJobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "streamEnabled", this.streamEnabled);
        BuilderUtils.appendProperty(sb, "preferRestOverGrpc", this.preferRestOverGrpc);
        return sb.toString();
    }

    private boolean shouldUseDefaultCredentialsProvider() {
        return this.credentialsProvider == null && Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null;
    }

    private CredentialsProvider createDefaultCredentialsProvider() {
        OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
        int separatorIndex = this.gatewayAddress.lastIndexOf(58);
        if (separatorIndex > 0) {
            builder.audience(this.gatewayAddress.substring(0, separatorIndex));
        }
        return builder.build();
    }

    private static URI getURIFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse URI string", e);
        }
    }
}

