/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import com.google.protobuf.GeneratedMessageV3;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ZeebeClientFutureImpl<ClientResponse, BrokerResponse>
extends CompletableFuture<ClientResponse>
implements ZeebeFuture<ClientResponse>,
ClientResponseObserver<GeneratedMessageV3, BrokerResponse> {
    protected ClientCallStreamObserver<GeneratedMessageV3> clientCall;
    private final Function<BrokerResponse, ClientResponse> responseMapper;

    public ZeebeClientFutureImpl() {
        this(brokerResponse -> null);
    }

    public ZeebeClientFutureImpl(Function<BrokerResponse, ClientResponse> responseMapper) {
        this.responseMapper = responseMapper;
    }

    @Override
    public ClientResponse join() {
        try {
            return (ClientResponse)this.get();
        }
        catch (ExecutionException e) {
            throw this.transformExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting client response", e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel(mayInterruptIfRunning, null);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning, Throwable cause) {
        if (mayInterruptIfRunning && this.clientCall != null) {
            this.clientCall.cancel("Client call explicitly cancelled by user", cause);
            return true;
        }
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ClientResponse join(long timeout, TimeUnit unit) {
        try {
            return (ClientResponse)this.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw this.transformExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting client response", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Timed out waiting on client response", e);
        }
    }

    public void onNext(BrokerResponse brokerResponse) {
        try {
            this.complete(this.responseMapper.apply(brokerResponse));
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    public void onError(Throwable throwable) {
        this.completeExceptionally(throwable);
    }

    public void onCompleted() {
    }

    public void beforeStart(ClientCallStreamObserver<GeneratedMessageV3> requestStream) {
        if (this.isDone()) {
            requestStream.cancel("Call was completed by the client before it was started", null);
            return;
        }
        this.clientCall = requestStream;
    }

    private RuntimeException transformExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof StatusRuntimeException) {
            Status status = ((StatusRuntimeException)cause).getStatus();
            throw new ClientStatusException(status, (Throwable)e);
        }
        throw new ClientException(e);
    }
}

