/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * IncidentFilterRequest
 */
@JsonPropertyOrder({
  IncidentFilterRequest.JSON_PROPERTY_KEY,
  IncidentFilterRequest.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  IncidentFilterRequest.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  IncidentFilterRequest.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  IncidentFilterRequest.JSON_PROPERTY_ERROR_TYPE,
  IncidentFilterRequest.JSON_PROPERTY_ERROR_MESSAGE,
  IncidentFilterRequest.JSON_PROPERTY_FLOW_NODE_ID,
  IncidentFilterRequest.JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY,
  IncidentFilterRequest.JSON_PROPERTY_CREATION_TIME,
  IncidentFilterRequest.JSON_PROPERTY_STATE,
  IncidentFilterRequest.JSON_PROPERTY_JOB_KEY,
  IncidentFilterRequest.JSON_PROPERTY_TREE_PATH,
  IncidentFilterRequest.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-28T16:53:53.401346729Z[GMT]", comments = "Generator version: 7.8.0")
public class IncidentFilterRequest {
  public static final String JSON_PROPERTY_KEY = "key";
  private Long key;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private Long processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  private Long processInstanceKey;

  /**
   * Incident error type with a defined set of values.
   */
  public enum ErrorTypeEnum {
    UNSPECIFIED("UNSPECIFIED"),
    
    UNKNOWN("UNKNOWN"),
    
    IO_MAPPING_ERROR("IO_MAPPING_ERROR"),
    
    JOB_NO_RETRIES("JOB_NO_RETRIES"),
    
    CONDITION_ERROR("CONDITION_ERROR"),
    
    EXTRACT_VALUE_ERROR("EXTRACT_VALUE_ERROR"),
    
    CALLED_ELEMENT_ERROR("CALLED_ELEMENT_ERROR"),
    
    UNHANDLED_ERROR_EVENT("UNHANDLED_ERROR_EVENT"),
    
    MESSAGE_SIZE_EXCEEDED("MESSAGE_SIZE_EXCEEDED"),
    
    CALLED_DECISION_ERROR("CALLED_DECISION_ERROR"),
    
    DECISION_EVALUATION_ERROR("DECISION_EVALUATION_ERROR"),
    
    FORM_NOT_FOUND("FORM_NOT_FOUND"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ErrorTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorTypeEnum fromValue(String value) {
      for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  private ErrorTypeEnum errorType;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private String errorMessage;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  private String flowNodeId;

  public static final String JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY = "flowNodeInstanceKey";
  private Long flowNodeInstanceKey;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  private String creationTime;

  /**
   * State of this incident with a defined set of values.
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    MIGRATED("MIGRATED"),
    
    RESOLVED("RESOLVED"),
    
    PENDING("PENDING"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  private Long jobKey;

  public static final String JSON_PROPERTY_TREE_PATH = "treePath";
  private String treePath;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public IncidentFilterRequest() {
  }

  public IncidentFilterRequest key(Long key) {
    
    this.key = key;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this incident.
   * @return key
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKey(Long key) {
    this.key = key;
  }

  public IncidentFilterRequest processDefinitionKey(Long processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this incident.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public IncidentFilterRequest processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process id associated to this incident.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentFilterRequest processInstanceKey(Long processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this incident.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public IncidentFilterRequest errorType(ErrorTypeEnum errorType) {
    
    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   * @return errorType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorTypeEnum getErrorType() {
    return errorType;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorType(ErrorTypeEnum errorType) {
    this.errorType = errorType;
  }

  public IncidentFilterRequest errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message which describes the error in more detail.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentFilterRequest flowNodeId(String flowNodeId) {
    
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node id associated to this incident.
   * @return flowNodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeId() {
    return flowNodeId;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public IncidentFilterRequest flowNodeInstanceKey(Long flowNodeInstanceKey) {
    
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The flow node instance key associated to this incident.
   * @return flowNodeInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public IncidentFilterRequest creationTime(String creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationTime() {
    return creationTime;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentFilterRequest state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }

  public IncidentFilterRequest jobKey(Long jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The job key, if exists, associated with this incident.
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(Long jobKey) {
    this.jobKey = jobKey;
  }

  public IncidentFilterRequest treePath(String treePath) {
    
    this.treePath = treePath;
    return this;
  }

  /**
   * The path from process instance via flow node ids and flow node instance keys leading to this incident.
   * @return treePath
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTreePath() {
    return treePath;
  }


  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTreePath(String treePath) {
    this.treePath = treePath;
  }

  public IncidentFilterRequest tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentFilterRequest incidentFilterRequest = (IncidentFilterRequest) o;
    return Objects.equals(this.key, incidentFilterRequest.key) &&
        Objects.equals(this.processDefinitionKey, incidentFilterRequest.processDefinitionKey) &&
        Objects.equals(this.processDefinitionId, incidentFilterRequest.processDefinitionId) &&
        Objects.equals(this.processInstanceKey, incidentFilterRequest.processInstanceKey) &&
        Objects.equals(this.errorType, incidentFilterRequest.errorType) &&
        Objects.equals(this.errorMessage, incidentFilterRequest.errorMessage) &&
        Objects.equals(this.flowNodeId, incidentFilterRequest.flowNodeId) &&
        Objects.equals(this.flowNodeInstanceKey, incidentFilterRequest.flowNodeInstanceKey) &&
        Objects.equals(this.creationTime, incidentFilterRequest.creationTime) &&
        Objects.equals(this.state, incidentFilterRequest.state) &&
        Objects.equals(this.jobKey, incidentFilterRequest.jobKey) &&
        Objects.equals(this.treePath, incidentFilterRequest.treePath) &&
        Objects.equals(this.tenantId, incidentFilterRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, processDefinitionKey, processDefinitionId, processInstanceKey, errorType, errorMessage, flowNodeId, flowNodeInstanceKey, creationTime, state, jobKey, treePath, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentFilterRequest {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    treePath: ").append(toIndentedString(treePath)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `key` to the URL query string
    if (getKey() != null) {
      try {
        joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorType` to the URL query string
    if (getErrorType() != null) {
      try {
        joiner.add(String.format("%serrorType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeId` to the URL query string
    if (getFlowNodeId() != null) {
      try {
        joiner.add(String.format("%sflowNodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeInstanceKey` to the URL query string
    if (getFlowNodeInstanceKey() != null) {
      try {
        joiner.add(String.format("%sflowNodeInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationTime` to the URL query string
    if (getCreationTime() != null) {
      try {
        joiner.add(String.format("%screationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobKey` to the URL query string
    if (getJobKey() != null) {
      try {
        joiner.add(String.format("%sjobKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `treePath` to the URL query string
    if (getTreePath() != null) {
      try {
        joiner.add(String.format("%streePath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTreePath()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

