/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobActivationRequest
 */
@JsonPropertyOrder({
  JobActivationRequest.JSON_PROPERTY_TYPE,
  JobActivationRequest.JSON_PROPERTY_WORKER,
  JobActivationRequest.JSON_PROPERTY_TIMEOUT,
  JobActivationRequest.JSON_PROPERTY_MAX_JOBS_TO_ACTIVATE,
  JobActivationRequest.JSON_PROPERTY_FETCH_VARIABLE,
  JobActivationRequest.JSON_PROPERTY_REQUEST_TIMEOUT,
  JobActivationRequest.JSON_PROPERTY_TENANT_IDS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-28T16:53:53.401346729Z[GMT]", comments = "Generator version: 7.8.0")
public class JobActivationRequest {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_WORKER = "worker";
  private String worker;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private Long timeout;

  public static final String JSON_PROPERTY_MAX_JOBS_TO_ACTIVATE = "maxJobsToActivate";
  private Integer maxJobsToActivate;

  public static final String JSON_PROPERTY_FETCH_VARIABLE = "fetchVariable";
  private List<String> fetchVariable;

  public static final String JSON_PROPERTY_REQUEST_TIMEOUT = "requestTimeout";
  private Long requestTimeout = 0l;

  public static final String JSON_PROPERTY_TENANT_IDS = "tenantIds";
  private List<String> tenantIds;

  public JobActivationRequest() {
  }

  public JobActivationRequest type(String type) {
    
    this.type = type;
    return this;
  }

  /**
   * the job type, as defined in the BPMN process (e.g. &lt;zeebe:taskDefinition type&#x3D;\&quot;payment-service\&quot; /&gt;) 
   * @return type
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }

  public JobActivationRequest worker(String worker) {
    
    this.worker = worker;
    return this;
  }

  /**
   * the name of the worker activating the jobs, mostly used for logging purposes
   * @return worker
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWorker() {
    return worker;
  }


  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorker(String worker) {
    this.worker = worker;
  }

  public JobActivationRequest timeout(Long timeout) {
    
    this.timeout = timeout;
    return this;
  }

  /**
   * a job returned after this call will not be activated by another call until the timeout (in ms) has been reached 
   * @return timeout
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimeout(Long timeout) {
    this.timeout = timeout;
  }

  public JobActivationRequest maxJobsToActivate(Integer maxJobsToActivate) {
    
    this.maxJobsToActivate = maxJobsToActivate;
    return this;
  }

  /**
   * the maximum jobs to activate by this request
   * @return maxJobsToActivate
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MAX_JOBS_TO_ACTIVATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxJobsToActivate() {
    return maxJobsToActivate;
  }


  @JsonProperty(JSON_PROPERTY_MAX_JOBS_TO_ACTIVATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxJobsToActivate(Integer maxJobsToActivate) {
    this.maxJobsToActivate = maxJobsToActivate;
  }

  public JobActivationRequest fetchVariable(List<String> fetchVariable) {
    
    this.fetchVariable = fetchVariable;
    return this;
  }

  public JobActivationRequest addFetchVariableItem(String fetchVariableItem) {
    if (this.fetchVariable == null) {
      this.fetchVariable = new ArrayList<>();
    }
    this.fetchVariable.add(fetchVariableItem);
    return this;
  }

  /**
   * a list of variables to fetch as the job variables; if empty, all visible variables at the time of activation for the scope of the job will be returned 
   * @return fetchVariable
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FETCH_VARIABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFetchVariable() {
    return fetchVariable;
  }


  @JsonProperty(JSON_PROPERTY_FETCH_VARIABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFetchVariable(List<String> fetchVariable) {
    this.fetchVariable = fetchVariable;
  }

  public JobActivationRequest requestTimeout(Long requestTimeout) {
    
    this.requestTimeout = requestTimeout;
    return this;
  }

  /**
   * The request will be completed when at least one job is activated or after the requestTimeout (in ms). If the requestTimeout &#x3D; 0, a default timeout is used. If the requestTimeout &lt; 0, long polling is disabled and the request is completed immediately, even when no job is activated. 
   * @return requestTimeout
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUEST_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRequestTimeout() {
    return requestTimeout;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestTimeout(Long requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  public JobActivationRequest tenantIds(List<String> tenantIds) {
    
    this.tenantIds = tenantIds;
    return this;
  }

  public JobActivationRequest addTenantIdsItem(String tenantIdsItem) {
    if (this.tenantIds == null) {
      this.tenantIds = new ArrayList<>();
    }
    this.tenantIds.add(tenantIdsItem);
    return this;
  }

  /**
   * a list of IDs of tenants for which to activate jobs
   * @return tenantIds
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTenantIds() {
    return tenantIds;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantIds(List<String> tenantIds) {
    this.tenantIds = tenantIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobActivationRequest jobActivationRequest = (JobActivationRequest) o;
    return Objects.equals(this.type, jobActivationRequest.type) &&
        Objects.equals(this.worker, jobActivationRequest.worker) &&
        Objects.equals(this.timeout, jobActivationRequest.timeout) &&
        Objects.equals(this.maxJobsToActivate, jobActivationRequest.maxJobsToActivate) &&
        Objects.equals(this.fetchVariable, jobActivationRequest.fetchVariable) &&
        Objects.equals(this.requestTimeout, jobActivationRequest.requestTimeout) &&
        Objects.equals(this.tenantIds, jobActivationRequest.tenantIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, worker, timeout, maxJobsToActivate, fetchVariable, requestTimeout, tenantIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobActivationRequest {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    maxJobsToActivate: ").append(toIndentedString(maxJobsToActivate)).append("\n");
    sb.append("    fetchVariable: ").append(toIndentedString(fetchVariable)).append("\n");
    sb.append("    requestTimeout: ").append(toIndentedString(requestTimeout)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `worker` to the URL query string
    if (getWorker() != null) {
      try {
        joiner.add(String.format("%sworker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorker()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timeout` to the URL query string
    if (getTimeout() != null) {
      try {
        joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxJobsToActivate` to the URL query string
    if (getMaxJobsToActivate() != null) {
      try {
        joiner.add(String.format("%smaxJobsToActivate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxJobsToActivate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `fetchVariable` to the URL query string
    if (getFetchVariable() != null) {
      for (int i = 0; i < getFetchVariable().size(); i++) {
        try {
          joiner.add(String.format("%sfetchVariable%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getFetchVariable().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `requestTimeout` to the URL query string
    if (getRequestTimeout() != null) {
      try {
        joiner.add(String.format("%srequestTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRequestTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIds` to the URL query string
    if (getTenantIds() != null) {
      for (int i = 0; i < getTenantIds().size(); i++) {
        try {
          joiner.add(String.format("%stenantIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

