/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.ModifyProcessInstanceVariableInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Instructions describing which elements should be activated in which scopes and which variables should be created. 
 */
@JsonPropertyOrder({
  ModifyProcessInstanceActivateInstruction.JSON_PROPERTY_ELEMENT_ID,
  ModifyProcessInstanceActivateInstruction.JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY,
  ModifyProcessInstanceActivateInstruction.JSON_PROPERTY_VARIABLE_INSTRUCTIONS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-28T16:53:53.401346729Z[GMT]", comments = "Generator version: 7.8.0")
public class ModifyProcessInstanceActivateInstruction {
  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  private String elementId;

  public static final String JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY = "ancestorElementInstanceKey";
  private Long ancestorElementInstanceKey = -1l;

  public static final String JSON_PROPERTY_VARIABLE_INSTRUCTIONS = "variableInstructions";
  private List<ModifyProcessInstanceVariableInstruction> variableInstructions = new ArrayList<>();

  public ModifyProcessInstanceActivateInstruction() {
  }

  public ModifyProcessInstanceActivateInstruction elementId(String elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The ID of the element that should be activated.
   * @return elementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public ModifyProcessInstanceActivateInstruction ancestorElementInstanceKey(Long ancestorElementInstanceKey) {
    
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
    return this;
  }

  /**
   * The key of the ancestor scope the element instance should be created in. Set to -1 to create the new element instance within an existing element instance of the flow scope. 
   * @return ancestorElementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAncestorElementInstanceKey() {
    return ancestorElementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncestorElementInstanceKey(Long ancestorElementInstanceKey) {
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
  }

  public ModifyProcessInstanceActivateInstruction variableInstructions(List<ModifyProcessInstanceVariableInstruction> variableInstructions) {
    
    this.variableInstructions = variableInstructions;
    return this;
  }

  public ModifyProcessInstanceActivateInstruction addVariableInstructionsItem(ModifyProcessInstanceVariableInstruction variableInstructionsItem) {
    if (this.variableInstructions == null) {
      this.variableInstructions = new ArrayList<>();
    }
    this.variableInstructions.add(variableInstructionsItem);
    return this;
  }

  /**
   * Get variableInstructions
   * @return variableInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ModifyProcessInstanceVariableInstruction> getVariableInstructions() {
    return variableInstructions;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariableInstructions(List<ModifyProcessInstanceVariableInstruction> variableInstructions) {
    this.variableInstructions = variableInstructions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyProcessInstanceActivateInstruction modifyProcessInstanceActivateInstruction = (ModifyProcessInstanceActivateInstruction) o;
    return Objects.equals(this.elementId, modifyProcessInstanceActivateInstruction.elementId) &&
        Objects.equals(this.ancestorElementInstanceKey, modifyProcessInstanceActivateInstruction.ancestorElementInstanceKey) &&
        Objects.equals(this.variableInstructions, modifyProcessInstanceActivateInstruction.variableInstructions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementId, ancestorElementInstanceKey, variableInstructions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyProcessInstanceActivateInstruction {\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    ancestorElementInstanceKey: ").append(toIndentedString(ancestorElementInstanceKey)).append("\n");
    sb.append("    variableInstructions: ").append(toIndentedString(variableInstructions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      try {
        joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ancestorElementInstanceKey` to the URL query string
    if (getAncestorElementInstanceKey() != null) {
      try {
        joiner.add(String.format("%sancestorElementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAncestorElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableInstructions` to the URL query string
    if (getVariableInstructions() != null) {
      for (int i = 0; i < getVariableInstructions().size(); i++) {
        if (getVariableInstructions().get(i) != null) {
          joiner.add(getVariableInstructions().get(i).toUrlQueryString(String.format("%svariableInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

