/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DeploymentDecisionRequirements
 */
@JsonPropertyOrder({
  DeploymentDecisionRequirements.JSON_PROPERTY_DECISION_REQUIREMENTS_ID,
  DeploymentDecisionRequirements.JSON_PROPERTY_VERSION,
  DeploymentDecisionRequirements.JSON_PROPERTY_DECISION_REQUIREMENTS_NAME,
  DeploymentDecisionRequirements.JSON_PROPERTY_TENANT_ID,
  DeploymentDecisionRequirements.JSON_PROPERTY_DECISION_REQUIREMENTS_KEY,
  DeploymentDecisionRequirements.JSON_PROPERTY_RESOURCE_NAME
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-03T16:56:13.176544526Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentDecisionRequirements {
  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  private String decisionRequirementsId;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_NAME = "decisionRequirementsName";
  private String decisionRequirementsName;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_KEY = "decisionRequirementsKey";
  private Long decisionRequirementsKey;

  public static final String JSON_PROPERTY_RESOURCE_NAME = "resourceName";
  private String resourceName;

  public DeploymentDecisionRequirements() {
  }

  public DeploymentDecisionRequirements decisionRequirementsId(String decisionRequirementsId) {
    
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn decision requirements ID, as parsed during deployment; together with the versions forms a unique identifier for a specific decision. 
   * @return decisionRequirementsId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DeploymentDecisionRequirements version(Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * The assigned decision requirements version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentDecisionRequirements decisionRequirementsName(String decisionRequirementsName) {
    
    this.decisionRequirementsName = decisionRequirementsName;
    return this;
  }

  /**
   * The DMN name of the decision requirements, as parsed during deployment.
   * @return decisionRequirementsName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsName() {
    return decisionRequirementsName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsName(String decisionRequirementsName) {
    this.decisionRequirementsName = decisionRequirementsName;
  }

  public DeploymentDecisionRequirements tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision requirements.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecisionRequirements decisionRequirementsKey(Long decisionRequirementsKey) {
    
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned decision requirements key, which acts as a unique identifier for this decision requirements. 
   * @return decisionRequirementsKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public DeploymentDecisionRequirements resourceName(String resourceName) {
    
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this decision requirements was parsed.
   * @return resourceName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceName() {
    return resourceName;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecisionRequirements deploymentDecisionRequirements = (DeploymentDecisionRequirements) o;
    return Objects.equals(this.decisionRequirementsId, deploymentDecisionRequirements.decisionRequirementsId) &&
        Objects.equals(this.version, deploymentDecisionRequirements.version) &&
        Objects.equals(this.decisionRequirementsName, deploymentDecisionRequirements.decisionRequirementsName) &&
        Objects.equals(this.tenantId, deploymentDecisionRequirements.tenantId) &&
        Objects.equals(this.decisionRequirementsKey, deploymentDecisionRequirements.decisionRequirementsKey) &&
        Objects.equals(this.resourceName, deploymentDecisionRequirements.resourceName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionRequirementsId, version, decisionRequirementsName, tenantId, decisionRequirementsKey, resourceName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecisionRequirements {\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    decisionRequirementsName: ").append(toIndentedString(decisionRequirementsName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionRequirementsId` to the URL query string
    if (getDecisionRequirementsId() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsName` to the URL query string
    if (getDecisionRequirementsName() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsKey` to the URL query string
    if (getDecisionRequirementsKey() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceName` to the URL query string
    if (getResourceName() != null) {
      try {
        joiner.add(String.format("%sresourceName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

