/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.zeebe.client.protocol.rest.MatchedDecisionRuleItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * List of decisions that were evaluated within the requested decision evaluation.
 */
@JsonPropertyOrder({
  EvaluatedDecisionItem.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  EvaluatedDecisionItem.JSON_PROPERTY_DECISION_DEFINITION_ID,
  EvaluatedDecisionItem.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  EvaluatedDecisionItem.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  EvaluatedDecisionItem.JSON_PROPERTY_DECISION_DEFINITION_TYPE,
  EvaluatedDecisionItem.JSON_PROPERTY_OUTPUT,
  EvaluatedDecisionItem.JSON_PROPERTY_TENANT_ID,
  EvaluatedDecisionItem.JSON_PROPERTY_MATCHED_RULES,
  EvaluatedDecisionItem.JSON_PROPERTY_EVALUATED_INPUTS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-03T16:56:13.176544526Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluatedDecisionItem {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  private Long decisionDefinitionKey;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION = "decisionDefinitionVersion";
  private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_TYPE = "decisionDefinitionType";
  private String decisionDefinitionType;

  public static final String JSON_PROPERTY_OUTPUT = "output";
  private String output;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public static final String JSON_PROPERTY_MATCHED_RULES = "matchedRules";
  private List<MatchedDecisionRuleItem> matchedRules = new ArrayList<>();

  public static final String JSON_PROPERTY_EVALUATED_INPUTS = "evaluatedInputs";
  private List<EvaluatedDecisionInputItem> evaluatedInputs = new ArrayList<>();

  public EvaluatedDecisionItem() {
  }

  public EvaluatedDecisionItem decisionDefinitionKey(Long decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the decision which was evaluate.
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public EvaluatedDecisionItem decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which was evaluated.
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluatedDecisionItem decisionDefinitionName(String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the decision which was evaluated.
   * @return decisionDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public EvaluatedDecisionItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision which was evaluated.
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public EvaluatedDecisionItem decisionDefinitionType(String decisionDefinitionType) {
    
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * The type of the decision which was evaluated.
   * @return decisionDefinitionType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionType() {
    return decisionDefinitionType;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionType(String decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public EvaluatedDecisionItem output(String output) {
    
    this.output = output;
    return this;
  }

  /**
   * JSON document that will instantiate the result of the decision which was evaluated. 
   * @return output
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOutput() {
    return output;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutput(String output) {
    this.output = output;
  }

  public EvaluatedDecisionItem tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the evaluated decision.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public EvaluatedDecisionItem matchedRules(List<MatchedDecisionRuleItem> matchedRules) {
    
    this.matchedRules = matchedRules;
    return this;
  }

  public EvaluatedDecisionItem addMatchedRulesItem(MatchedDecisionRuleItem matchedRulesItem) {
    if (this.matchedRules == null) {
      this.matchedRules = new ArrayList<>();
    }
    this.matchedRules.add(matchedRulesItem);
    return this;
  }

  /**
   * Get matchedRules
   * @return matchedRules
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MATCHED_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MatchedDecisionRuleItem> getMatchedRules() {
    return matchedRules;
  }


  @JsonProperty(JSON_PROPERTY_MATCHED_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMatchedRules(List<MatchedDecisionRuleItem> matchedRules) {
    this.matchedRules = matchedRules;
  }

  public EvaluatedDecisionItem evaluatedInputs(List<EvaluatedDecisionInputItem> evaluatedInputs) {
    
    this.evaluatedInputs = evaluatedInputs;
    return this;
  }

  public EvaluatedDecisionItem addEvaluatedInputsItem(EvaluatedDecisionInputItem evaluatedInputsItem) {
    if (this.evaluatedInputs == null) {
      this.evaluatedInputs = new ArrayList<>();
    }
    this.evaluatedInputs.add(evaluatedInputsItem);
    return this;
  }

  /**
   * Get evaluatedInputs
   * @return evaluatedInputs
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATED_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EvaluatedDecisionInputItem> getEvaluatedInputs() {
    return evaluatedInputs;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATED_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluatedInputs(List<EvaluatedDecisionInputItem> evaluatedInputs) {
    this.evaluatedInputs = evaluatedInputs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluatedDecisionItem evaluatedDecisionItem = (EvaluatedDecisionItem) o;
    return Objects.equals(this.decisionDefinitionKey, evaluatedDecisionItem.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, evaluatedDecisionItem.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, evaluatedDecisionItem.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, evaluatedDecisionItem.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, evaluatedDecisionItem.decisionDefinitionType) &&
        Objects.equals(this.output, evaluatedDecisionItem.output) &&
        Objects.equals(this.tenantId, evaluatedDecisionItem.tenantId) &&
        Objects.equals(this.matchedRules, evaluatedDecisionItem.matchedRules) &&
        Objects.equals(this.evaluatedInputs, evaluatedDecisionItem.evaluatedInputs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, output, tenantId, matchedRules, evaluatedInputs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluatedDecisionItem {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    output: ").append(toIndentedString(output)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    matchedRules: ").append(toIndentedString(matchedRules)).append("\n");
    sb.append("    evaluatedInputs: ").append(toIndentedString(evaluatedInputs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionDefinitionKey` to the URL query string
    if (getDecisionDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionVersion` to the URL query string
    if (getDecisionDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionType` to the URL query string
    if (getDecisionDefinitionType() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `output` to the URL query string
    if (getOutput() != null) {
      try {
        joiner.add(String.format("%soutput%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOutput()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `matchedRules` to the URL query string
    if (getMatchedRules() != null) {
      for (int i = 0; i < getMatchedRules().size(); i++) {
        if (getMatchedRules().get(i) != null) {
          joiner.add(getMatchedRules().get(i).toUrlQueryString(String.format("%smatchedRules%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `evaluatedInputs` to the URL query string
    if (getEvaluatedInputs() != null) {
      for (int i = 0; i < getEvaluatedInputs().size(); i++) {
        if (getEvaluatedInputs().get(i) != null) {
          joiner.add(getEvaluatedInputs().get(i).toUrlQueryString(String.format("%sevaluatedInputs%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

