/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.MigrateProcessInstanceMappingInstruction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"targetProcessDefinitionKey", "mappingInstructions", "operationReference"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MigrateProcessInstanceRequest {
    public static final String JSON_PROPERTY_TARGET_PROCESS_DEFINITION_KEY = "targetProcessDefinitionKey";
    private Long targetProcessDefinitionKey;
    public static final String JSON_PROPERTY_MAPPING_INSTRUCTIONS = "mappingInstructions";
    private List<MigrateProcessInstanceMappingInstruction> mappingInstructions = new ArrayList<MigrateProcessInstanceMappingInstruction>();
    public static final String JSON_PROPERTY_OPERATION_REFERENCE = "operationReference";
    private Long operationReference;

    public MigrateProcessInstanceRequest targetProcessDefinitionKey(Long targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="targetProcessDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTargetProcessDefinitionKey() {
        return this.targetProcessDefinitionKey;
    }

    @JsonProperty(value="targetProcessDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTargetProcessDefinitionKey(Long targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    }

    public MigrateProcessInstanceRequest mappingInstructions(List<MigrateProcessInstanceMappingInstruction> mappingInstructions) {
        this.mappingInstructions = mappingInstructions;
        return this;
    }

    public MigrateProcessInstanceRequest addMappingInstructionsItem(MigrateProcessInstanceMappingInstruction mappingInstructionsItem) {
        if (this.mappingInstructions == null) {
            this.mappingInstructions = new ArrayList<MigrateProcessInstanceMappingInstruction>();
        }
        this.mappingInstructions.add(mappingInstructionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="mappingInstructions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MigrateProcessInstanceMappingInstruction> getMappingInstructions() {
        return this.mappingInstructions;
    }

    @JsonProperty(value="mappingInstructions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMappingInstructions(List<MigrateProcessInstanceMappingInstruction> mappingInstructions) {
        this.mappingInstructions = mappingInstructions;
    }

    public MigrateProcessInstanceRequest operationReference(Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Nullable
    @JsonProperty(value="operationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOperationReference() {
        return this.operationReference;
    }

    @JsonProperty(value="operationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationReference(Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrateProcessInstanceRequest migrateProcessInstanceRequest = (MigrateProcessInstanceRequest)o;
        return Objects.equals(this.targetProcessDefinitionKey, migrateProcessInstanceRequest.targetProcessDefinitionKey) && Objects.equals(this.mappingInstructions, migrateProcessInstanceRequest.mappingInstructions) && Objects.equals(this.operationReference, migrateProcessInstanceRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.targetProcessDefinitionKey, this.mappingInstructions, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrateProcessInstanceRequest {\n");
        sb.append("    targetProcessDefinitionKey: ").append(this.toIndentedString(this.targetProcessDefinitionKey)).append("\n");
        sb.append("    mappingInstructions: ").append(this.toIndentedString(this.mappingInstructions)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTargetProcessDefinitionKey() != null) {
            try {
                joiner.add(String.format("%stargetProcessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTargetProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMappingInstructions() != null) {
            for (int i = 0; i < this.getMappingInstructions().size(); ++i) {
                if (this.getMappingInstructions().get(i) == null) continue;
                joiner.add(this.getMappingInstructions().get(i).toUrlQueryString(String.format("%smappingInstructions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getOperationReference() != null) {
            try {
                joiner.add(String.format("%soperationReference%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOperationReference()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

