/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.ExperimentalApi;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateDocumentCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DocumentReferenceResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.DocumentReferenceResponseImpl;
import io.camunda.zeebe.client.protocol.rest.DocumentMetadata;
import io.camunda.zeebe.client.protocol.rest.DocumentReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalApi(value="https://github.com/camunda/issues/issues/841")
public class CreateDocumentCommandImpl
implements CreateDocumentCommandStep1,
CreateDocumentCommandStep1.CreateDocumentCommandStep2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDocumentCommandImpl.class);
    private String documentId;
    private String storeId;
    private InputStream content;
    private final DocumentMetadata metadata = new DocumentMetadata();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateDocumentCommandImpl(JsonMapper jsonMapper, HttpClient httpClient, ZeebeClientConfiguration configuration) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<DocumentReferenceResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZeebeFuture<DocumentReferenceResponse> send() {
        try {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
            String name = Optional.ofNullable(this.metadata.getFileName()).orElse("document-" + this.documentId);
            entityBuilder.addBinaryBody("file", this.content, ContentType.DEFAULT_BINARY, name);
            String metadataString = this.jsonMapper.toJson(this.metadata);
            entityBuilder.addPart("metadata", (ContentBody)new StringBody(metadataString, ContentType.APPLICATION_JSON));
            HttpZeebeFuture<DocumentReferenceResponse> result = new HttpZeebeFuture<DocumentReferenceResponse>();
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (this.documentId != null) {
                queryParams.put("documentId", this.documentId);
            }
            if (this.storeId != null) {
                queryParams.put("storeId", this.storeId);
            }
            this.httpClient.postMultipart("/documents", queryParams, entityBuilder, this.httpRequestConfig.build(), DocumentReference.class, DocumentReferenceResponseImpl::new, result);
            HttpZeebeFuture<DocumentReferenceResponse> httpZeebeFuture = result;
            return httpZeebeFuture;
        }
        finally {
            try {
                this.content.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close content stream", (Throwable)e);
            }
        }
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(InputStream content) {
        ArgumentUtil.ensureNotNull("content", content);
        this.content = content;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(byte[] content) {
        ArgumentUtil.ensureNotNull("content", content);
        this.content = new ByteArrayInputStream(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(String content) {
        ArgumentUtil.ensureNotNull("content", content);
        this.content = new ByteArrayInputStream(content.getBytes());
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 contentType(String contentType) {
        this.metadata.setContentType(contentType);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 fileName(String name) {
        this.metadata.setFileName(name);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 timeToLive(Duration timeToLive) {
        OffsetDateTime expiresAt = OffsetDateTime.now().plus(timeToLive);
        this.metadata.setExpiresAt(expiresAt.toString());
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(String key, Object value) {
        ArgumentUtil.ensureNotNull("key", key);
        ArgumentUtil.ensureNotNull("value", value);
        if (this.metadata.getCustomProperties() == null) {
            this.metadata.setCustomProperties(new HashMap<String, Object>());
        }
        this.metadata.getCustomProperties().put(key, value);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(Map<String, Object> customMetadata) {
        ArgumentUtil.ensureNotNull("customMetadata", customMetadata);
        if (this.metadata.getCustomProperties() == null) {
            this.metadata.setCustomProperties(new HashMap<String, Object>());
        }
        this.metadata.getCustomProperties().putAll(customMetadata);
        return this;
    }
}

