/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateDocumentLinkCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DocumentLinkResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.DocumentLinkResponseImpl;
import io.camunda.zeebe.client.protocol.rest.DocumentLink;
import io.camunda.zeebe.client.protocol.rest.DocumentLinkRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateDocumentLinkCommandImpl
implements CreateDocumentLinkCommandStep1 {
    final Map<String, String> queryParams;
    final DocumentLinkRequest documentLinkRequest;
    private final String documentId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public CreateDocumentLinkCommandImpl(String documentId, String storeId, JsonMapper jsonMapper, HttpClient httpClient, ZeebeClientConfiguration configuration) {
        ArgumentUtil.ensureNotNull("documentId", documentId);
        this.documentId = documentId;
        this.queryParams = new HashMap<String, String>();
        if (storeId != null) {
            this.queryParams.put("storeId", storeId);
        }
        this.documentLinkRequest = new DocumentLinkRequest();
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public CreateDocumentLinkCommandStep1 storeId(String storeId) {
        ArgumentUtil.ensureNotNull("storeId", storeId);
        this.queryParams.put("storeId", storeId);
        return this;
    }

    @Override
    public CreateDocumentLinkCommandStep1 timeToLive(Duration timeToLive) {
        this.documentLinkRequest.setTimeToLive(timeToLive.toMillis());
        return this;
    }

    @Override
    public FinalCommandStep<DocumentLinkResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<DocumentLinkResponse> send() {
        HttpZeebeFuture<DocumentLinkResponse> result = new HttpZeebeFuture<DocumentLinkResponse>();
        this.httpClient.post(String.format("/documents/%s/links", this.documentId), this.queryParams, this.jsonMapper.toJson(this.documentLinkRequest), this.httpRequestConfig.build(), DocumentLink.class, DocumentLinkResponseImpl::new, result);
        return result;
    }
}

