/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateTenantCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CreateTenantResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.CreateTenantResponseImpl;
import io.camunda.zeebe.client.protocol.rest.TenantCreateRequest;
import io.camunda.zeebe.client.protocol.rest.TenantCreateResponse;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CreateTenantCommandImpl
implements CreateTenantCommandStep1 {
    private final TenantCreateRequest request = new TenantCreateRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateTenantCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public CreateTenantCommandStep1 tenantId(String tenantId) {
        this.request.setTenantId(tenantId);
        return this;
    }

    @Override
    public CreateTenantCommandStep1 name(String name) {
        this.request.setName(name);
        return this;
    }

    @Override
    public FinalCommandStep<CreateTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<CreateTenantResponse> send() {
        ArgumentUtil.ensureNotNull("tenantId", this.request.getTenantId());
        HttpZeebeFuture<CreateTenantResponse> result = new HttpZeebeFuture<CreateTenantResponse>();
        CreateTenantResponseImpl response = new CreateTenantResponseImpl();
        this.httpClient.post("/tenants", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantCreateResponse.class, response::setResponse, result);
        return result;
    }
}

