/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.protocol.rest.AuthorizationPatchRequest;
import io.camunda.zeebe.client.protocol.rest.PermissionDTO;
import io.camunda.zeebe.client.protocol.rest.PermissionTypeEnum;
import io.camunda.zeebe.client.protocol.rest.ResourceTypeEnum;
import java.util.List;

public class PatchAuthorizationCommand {
    private final AuthorizationPatchRequest request;
    private PermissionDTO currentPermission;

    public PatchAuthorizationCommand(AuthorizationPatchRequest.ActionEnum action) {
        this.request = new AuthorizationPatchRequest().action(action);
    }

    public void resourceType(ResourceTypeEnum resourceType) {
        ArgumentUtil.ensureNotNull("resourceType", (Object)resourceType);
        this.request.resourceType(resourceType);
    }

    public void permission(PermissionTypeEnum permissionType) {
        ArgumentUtil.ensureNotNull("permissionType", (Object)permissionType);
        this.currentPermission = new PermissionDTO();
        this.currentPermission.permissionType(permissionType);
        this.request.addPermissionsItem(this.currentPermission);
    }

    public void resourceIds(List<String> resourceIds) {
        ArgumentUtil.ensureNotNullOrEmpty("resourceIds", resourceIds);
        resourceIds.forEach(this::resourceId);
    }

    public void resourceId(String resourceId) {
        ArgumentUtil.ensureNotNullNorEmpty("resourceId", resourceId);
        this.currentPermission.addResourceIdsItem(resourceId);
    }

    public AuthorizationPatchRequest getRequest() {
        return this.request;
    }
}

