/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.RemovePermissionsCommandStep1;
import io.camunda.zeebe.client.api.response.RemovePermissionsResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.command.PatchAuthorizationCommand;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.AuthorizationPatchRequest;
import io.camunda.zeebe.client.protocol.rest.PermissionTypeEnum;
import io.camunda.zeebe.client.protocol.rest.ResourceTypeEnum;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class RemovePermissionsCommandImpl
implements RemovePermissionsCommandStep1,
RemovePermissionsCommandStep1.RemovePermissionsCommandStep2,
RemovePermissionsCommandStep1.RemovePermissionsCommandStep3,
RemovePermissionsCommandStep1.RemovePermissionsCommandStep4 {
    private final PatchAuthorizationCommand delegate;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final String path;
    private final RequestConfig.Builder httpRequestConfig;

    public RemovePermissionsCommandImpl(long ownerKey, HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.path = "/authorizations/" + ownerKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.delegate = new PatchAuthorizationCommand(AuthorizationPatchRequest.ActionEnum.REMOVE);
    }

    @Override
    public RemovePermissionsCommandStep1.RemovePermissionsCommandStep2 resourceType(ResourceTypeEnum resourceType) {
        this.delegate.resourceType(resourceType);
        return this;
    }

    @Override
    public RemovePermissionsCommandStep1.RemovePermissionsCommandStep3 permission(PermissionTypeEnum permissionType) {
        this.delegate.permission(permissionType);
        return this;
    }

    @Override
    public RemovePermissionsCommandStep1.RemovePermissionsCommandStep4 resourceIds(List<String> resourceIds) {
        this.delegate.resourceIds(resourceIds);
        return this;
    }

    @Override
    public RemovePermissionsCommandStep1.RemovePermissionsCommandStep4 resourceId(String resourceId) {
        this.delegate.resourceId(resourceId);
        return this;
    }

    @Override
    public FinalCommandStep<RemovePermissionsResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<RemovePermissionsResponse> send() {
        HttpZeebeFuture<RemovePermissionsResponse> result = new HttpZeebeFuture<RemovePermissionsResponse>();
        this.httpClient.patch(this.path, this.jsonMapper.toJson(this.delegate.getRequest()), this.httpRequestConfig.build(), result);
        return result;
    }
}

