/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.fetch.DecisionDefinitionGetRequest;
import io.camunda.zeebe.client.api.search.response.DecisionDefinition;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.DecisionDefinitionImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionDefinitionItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionDefinitionGetRequestImpl
implements DecisionDefinitionGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long decisionDefinitionKey;

    public DecisionDefinitionGetRequestImpl(HttpClient httpClient, long decisionDefinitionKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DecisionDefinitionGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<DecisionDefinition> send() {
        HttpZeebeFuture<DecisionDefinition> result = new HttpZeebeFuture<DecisionDefinition>();
        this.httpClient.get(String.format("/decision-definitions/%d", this.decisionDefinitionKey), this.httpRequestConfig.build(), DecisionDefinitionItem.class, DecisionDefinitionImpl::new, result);
        return result;
    }
}

