/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.DecisionInstanceGetRequest;
import io.camunda.zeebe.client.api.search.response.DecisionInstance;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.DecisionInstanceImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceGetQueryResponse;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionInstanceGetRequestImpl
implements DecisionInstanceGetRequest {
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String decisionInstanceId;

    public DecisionInstanceGetRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String decisionInstanceId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionInstanceId = decisionInstanceId;
    }

    @Override
    public FinalCommandStep<DecisionInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<DecisionInstance> send() {
        HttpZeebeFuture<DecisionInstance> result = new HttpZeebeFuture<DecisionInstance>();
        this.httpClient.get(String.format("/decision-instances/%s", this.decisionInstanceId), this.httpRequestConfig.build(), DecisionInstanceGetQueryResponse.class, resp -> new DecisionInstanceImpl((DecisionInstanceGetQueryResponse)resp, this.jsonMapper), result);
        return result;
    }
}

