/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.fetch.DecisionRequirementsGetRequest;
import io.camunda.zeebe.client.api.search.response.DecisionRequirements;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.DecisionRequirementsImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionRequirementsItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionRequirementsGetRequestImpl
implements DecisionRequirementsGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long decisionRequirementsKey;

    public DecisionRequirementsGetRequestImpl(HttpClient httpClient, long decisionRequirementsKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DecisionRequirementsGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<DecisionRequirements> send() {
        HttpZeebeFuture<DecisionRequirements> result = new HttpZeebeFuture<DecisionRequirements>();
        this.httpClient.get(String.format("/decision-requirements/%d", this.decisionRequirementsKey), this.httpRequestConfig.build(), DecisionRequirementsItem.class, DecisionRequirementsImpl::new, result);
        return result;
    }
}

