/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.DocumentContentGetRequest;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DocumentContentGetRequestImpl
implements DocumentContentGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String documentId;
    private String storeId;

    public DocumentContentGetRequestImpl(HttpClient httpClient, String documentId, String storeId, ZeebeClientConfiguration configuration) {
        ArgumentUtil.ensureNotNull("documentId", documentId);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.documentId = documentId;
        this.storeId = storeId;
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<InputStream> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<InputStream> send() {
        HttpZeebeFuture<InputStream> result = new HttpZeebeFuture<InputStream>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.storeId != null) {
            queryParams.put("storeId", this.storeId);
        }
        this.httpClient.get(String.format("/documents/%s", this.documentId), queryParams, this.httpRequestConfig.build(), InputStream.class, is -> is, result);
        return result;
    }

    @Override
    public DocumentContentGetRequest storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }
}

