/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.FlowNodeInstanceGetRequest;
import io.camunda.zeebe.client.api.search.response.FlowNodeInstance;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.protocol.rest.FlowNodeInstanceItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class FlowNodeInstanceGetRequestImpl
implements FlowNodeInstanceGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long flowNodeInstanceKey;

    public FlowNodeInstanceGetRequestImpl(HttpClient httpClient, long flowNodeInstanceKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.flowNodeInstanceKey = flowNodeInstanceKey;
    }

    @Override
    public FinalCommandStep<FlowNodeInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<FlowNodeInstance> send() {
        HttpZeebeFuture<FlowNodeInstance> result = new HttpZeebeFuture<FlowNodeInstance>();
        this.httpClient.get(String.format("/flownode-instances/%d", this.flowNodeInstanceKey), this.httpRequestConfig.build(), FlowNodeInstanceItem.class, SearchResponseMapper::toFlowNodeInstanceGetResponse, result);
        return result;
    }
}

