/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.IncidentGetRequest;
import io.camunda.zeebe.client.api.search.response.Incident;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.protocol.rest.IncidentItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentGetRequestImpl
implements IncidentGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long incidentKey;

    public IncidentGetRequestImpl(HttpClient httpClient, long incidentKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.incidentKey = incidentKey;
    }

    @Override
    public FinalCommandStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<Incident> send() {
        HttpZeebeFuture<Incident> result = new HttpZeebeFuture<Incident>();
        this.httpClient.get(String.format("/incidents/%d", this.incidentKey), this.httpRequestConfig.build(), IncidentItem.class, SearchResponseMapper::toIncidentGetResponse, result);
        return result;
    }
}

